/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.util.Immutables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIFODataContainer
implements DataContainer {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    final int segmentMask;
    final int segmentShift;
    final Segment[] segments;
    Set<Object> keySet;
    final LinkedEntry head = new LinkedEntry(null);
    final LinkedEntry tail = new LinkedEntry(null);

    public FIFODataContainer() {
        int cap;
        int c;
        int ssize;
        float loadFactor = 0.75f;
        int initialCapacity = 16;
        int concurrencyLevel = 16;
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(cap, loadFactor);
        }
        this.initLinks();
    }

    protected final boolean isMarkedForRemoval(LinkedEntry e) {
        return e != this.head && e != this.tail && e.e == null;
    }

    protected final boolean markPrevReference(LinkedEntry e) {
        if (this.isMarkedForRemoval(e.p)) {
            return false;
        }
        Marker m = new Marker(e.p);
        return e.casPrev(e.p, m);
    }

    protected final boolean markNextReference(LinkedEntry e) {
        if (this.isMarkedForRemoval(e.n)) {
            return false;
        }
        Marker m = new Marker(e.n);
        return e.casNext(e.n, m);
    }

    protected final void initLinks() {
        this.head.n = this.tail;
        this.head.p = this.tail;
        this.tail.n = this.head;
        this.tail.p = this.head;
    }

    protected final void unlink(LinkedEntry entry) {
        if (entry == this.head || entry == this.tail) {
            return;
        }
        LinkedEntry next;
        while (!this.isMarkedForRemoval(next = entry.n)) {
            LinkedEntry prev;
            if (!this.markNextReference(entry)) continue;
            next = entry.n;
            while (!this.isMarkedForRemoval(prev = entry.p) && !this.markPrevReference(entry)) {
            }
            prev = entry.p;
            LinkedEntry linkedEntry = this.correctPrev(prev.p, next.n);
        }
        return;
    }

    protected final void linkAtEnd(LinkedEntry entry) {
        LinkedEntry l1;
        LinkedEntry prev = this.tail.p;
        while (true) {
            entry.p = prev;
            entry.n = this.tail;
            if (prev.casNext(this.tail, entry)) break;
            prev = this.correctPrev(prev, this.tail);
        }
        while (!this.isMarkedForRemoval(l1 = this.tail.p) && entry.n == this.tail) {
            if (!this.tail.casPrev(l1, entry)) continue;
            if (!this.isMarkedForRemoval(entry.p)) break;
            entry = this.correctPrev(entry, this.tail);
            break;
        }
    }

    protected final LinkedEntry getNext(LinkedEntry current) {
        while (true) {
            boolean marked;
            if (current == this.tail) {
                return null;
            }
            LinkedEntry next = current.n;
            if (this.isMarkedForRemoval(next)) {
                next = next.n;
            }
            if ((marked = this.isMarkedForRemoval(next.n)) && !this.isMarkedForRemoval(current.n)) {
                this.markPrevReference(next);
                current.casNext(next, next.n.n);
                continue;
            }
            current = next;
            if (!marked && next != this.tail) break;
        }
        return current;
    }

    protected final LinkedEntry getPrev(LinkedEntry current) {
        while (current != this.head) {
            LinkedEntry prev = current.p;
            if (prev.n == current && !this.isMarkedForRemoval(current) && !this.isMarkedForRemoval(current.n)) {
                current = prev;
                if (current == this.head) continue;
                return current;
            }
            if (this.isMarkedForRemoval(current.n)) {
                current = this.getNext(current);
                continue;
            }
            LinkedEntry linkedEntry = this.correctPrev(prev, current);
        }
        return null;
    }

    protected final LinkedEntry correctPrev(LinkedEntry suggestedPreviousEntry, LinkedEntry currentEntry) {
        LinkedEntry link1;
        LinkedEntry lastLink = null;
        while (!this.isMarkedForRemoval(link1 = currentEntry.p)) {
            LinkedEntry prev2 = suggestedPreviousEntry.n;
            if (this.isMarkedForRemoval(prev2)) {
                if (lastLink != null) {
                    this.markPrevReference(suggestedPreviousEntry);
                    lastLink.casNext(suggestedPreviousEntry, prev2.p);
                    suggestedPreviousEntry = lastLink;
                    lastLink = null;
                    continue;
                }
                suggestedPreviousEntry = prev2 = suggestedPreviousEntry.p;
                continue;
            }
            if (prev2 != currentEntry) {
                lastLink = suggestedPreviousEntry;
                suggestedPreviousEntry = prev2;
                continue;
            }
            if (!currentEntry.casPrev(link1, suggestedPreviousEntry) || this.isMarkedForRemoval(suggestedPreviousEntry.p)) continue;
        }
        return suggestedPreviousEntry;
    }

    final int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    final Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    @Override
    public InternalCacheEntry get(Object k) {
        int h = this.hash(k.hashCode());
        Segment s = this.segmentFor(h);
        LinkedEntry le = s.get(k, h);
        InternalCacheEntry ice = null;
        if (le != null) {
            ice = le.e;
            if (this.isMarkedForRemoval(le)) {
                this.unlink(le);
            }
        }
        if (ice != null) {
            if (ice.isExpired()) {
                this.remove(k);
                ice = null;
            } else {
                ice.touch();
            }
        }
        return ice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object k, Object v, long lifespan, long maxIdle) {
        int h = this.hash(k.hashCode());
        Segment s = this.segmentFor(h);
        s.lock();
        boolean newEntry = false;
        try {
            InternalCacheEntry ice;
            LinkedEntry le = s.get(k, h);
            InternalCacheEntry internalCacheEntry = ice = le == null ? null : le.e;
            if (ice == null) {
                newEntry = true;
                ice = InternalEntryFactory.create(k, v, lifespan, maxIdle);
                le = new LinkedEntry(ice);
            } else {
                ice.setValue(v);
                le.e = ice = ice.setLifespan(lifespan).setMaxIdle(maxIdle);
            }
            s.locklessPut(k, h, le);
            if (newEntry) {
                this.linkAtEnd(le);
            }
        }
        finally {
            s.unlock();
        }
    }

    @Override
    public boolean containsKey(Object k) {
        int h = this.hash(k.hashCode());
        Segment s = this.segmentFor(h);
        LinkedEntry le = s.get(k, h);
        InternalCacheEntry ice = null;
        if (le != null) {
            ice = le.e;
            if (this.isMarkedForRemoval(le)) {
                this.unlink(le);
            }
        }
        if (ice != null && ice.isExpired()) {
            this.remove(k);
            ice = null;
        }
        return ice != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCacheEntry remove(Object k) {
        int h = this.hash(k.hashCode());
        Segment s = this.segmentFor(h);
        s.lock();
        InternalCacheEntry ice = null;
        try {
            LinkedEntry le = s.locklessRemove(k, h);
            if (le != null) {
                ice = le.e;
                this.unlink(le);
            }
        }
        finally {
            s.unlock();
        }
        if (ice == null || ice.isExpired()) {
            return null;
        }
        return ice;
    }

    @Override
    public int size() {
        Segment[] segs;
        int sz = 0;
        for (Segment s : segs = this.segments) {
            sz += s.count;
        }
        return sz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        for (Segment s : this.segments) {
            s.lock();
        }
        try {
            for (Segment s : this.segments) {
                s.locklessClear();
            }
            this.initLinks();
        }
        finally {
            for (Segment s : this.segments) {
                s.unlock();
            }
        }
    }

    @Override
    public Set<Object> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<Object> values() {
        return new Values();
    }

    @Override
    public Set<Map.Entry> entrySet() {
        return new EntrySet();
    }

    @Override
    public void purgeExpired() {
        for (InternalCacheEntry ice : this) {
            if (!ice.isExpired()) continue;
            this.remove(ice.getKey());
        }
    }

    @Override
    public Iterator<InternalCacheEntry> iterator() {
        return new EntryIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ValueIterator
    extends LinkedIterator
    implements Iterator<Object> {
        protected ValueIterator() {
        }

        @Override
        public Object next() {
            return this.current.e.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class KeyIterator
    extends LinkedIterator
    implements Iterator<Object> {
        protected KeyIterator() {
        }

        @Override
        public Object next() {
            return this.current.e.getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ImmutableEntryIterator
    extends LinkedIterator
    implements Iterator<Map.Entry> {
        protected ImmutableEntryIterator() {
        }

        @Override
        public Map.Entry next() {
            return Immutables.immutableEntry(this.current.e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class EntryIterator
    extends LinkedIterator
    implements Iterator<InternalCacheEntry> {
        protected EntryIterator() {
        }

        @Override
        public InternalCacheEntry next() {
            return this.current.e;
        }
    }

    protected abstract class LinkedIterator {
        LinkedEntry current;

        protected LinkedIterator() {
            this.current = FIFODataContainer.this.head;
        }

        public boolean hasNext() {
            if (this.current == FIFODataContainer.this.tail) {
                return false;
            }
            this.current = FIFODataContainer.this.getNext(this.current);
            return this.current != null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class EntrySet
    extends AbstractSet<Map.Entry> {
        protected EntrySet() {
        }

        @Override
        public Iterator<Map.Entry> iterator() {
            return new ImmutableEntryIterator();
        }

        @Override
        public int size() {
            return FIFODataContainer.this.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class Values
    extends AbstractCollection<Object> {
        protected Values() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return FIFODataContainer.this.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class KeySet
    extends AbstractSet<Object> {
        protected KeySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return FIFODataContainer.this.size();
        }
    }

    static final class Segment
    extends ReentrantLock {
        volatile transient int count;
        transient int threshold;
        volatile transient HashEntry[] table;
        final float loadFactor;

        Segment(int initialCapacity, float lf) {
            this.loadFactor = lf;
            this.setTable(new HashEntry[initialCapacity]);
        }

        static final Segment[] newArray(int i) {
            return new Segment[i];
        }

        final void setTable(HashEntry[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        final HashEntry getFirst(int hash) {
            HashEntry[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final LinkedEntry readValueUnderLock(HashEntry e) {
            this.lock();
            try {
                LinkedEntry linkedEntry = e.value;
                return linkedEntry;
            }
            finally {
                this.unlock();
            }
        }

        final LinkedEntry get(Object key, int hash) {
            if (this.count != 0) {
                HashEntry e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key)) {
                        LinkedEntry v = e.value;
                        if (v != null) {
                            return v;
                        }
                        return this.readValueUnderLock(e);
                    }
                    e = e.next;
                }
            }
            return null;
        }

        final LinkedEntry locklessPut(Object key, int hash, LinkedEntry value) {
            LinkedEntry oldValue;
            HashEntry first;
            int c = this.count;
            if (c++ > this.threshold) {
                this.rehash();
            }
            HashEntry[] tab = this.table;
            int index = hash & tab.length - 1;
            HashEntry e = first = tab[index];
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            if (e != null) {
                oldValue = e.value;
                e.value = value;
            } else {
                oldValue = null;
                tab[index] = new HashEntry(key, hash, first, value);
                this.count = c;
            }
            return oldValue;
        }

        final void rehash() {
            HashEntry[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashEntry[] newTable = new HashEntry[oldCapacity << 1];
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            for (int i = 0; i < oldCapacity; ++i) {
                int k;
                HashEntry e = oldTable[i];
                if (e == null) continue;
                HashEntry next = e.next;
                int idx = e.hash & sizeMask;
                if (next == null) {
                    newTable[idx] = e;
                    continue;
                }
                HashEntry lastRun = e;
                int lastIdx = idx;
                HashEntry last = next;
                while (last != null) {
                    k = last.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                HashEntry p = e;
                while (p != lastRun) {
                    k = p.hash & sizeMask;
                    HashEntry n = newTable[k];
                    newTable[k] = new HashEntry(p.key, p.hash, n, p.value);
                    p = p.next;
                }
            }
            this.table = newTable;
        }

        final LinkedEntry locklessRemove(Object key, int hash) {
            HashEntry first;
            int c = this.count - 1;
            HashEntry[] tab = this.table;
            int index = hash & tab.length - 1;
            HashEntry e = first = tab[index];
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            LinkedEntry oldValue = null;
            if (e != null) {
                oldValue = e.value;
                HashEntry newFirst = e.next;
                HashEntry p = first;
                while (p != e) {
                    newFirst = new HashEntry(p.key, p.hash, newFirst, p.value);
                    p = p.next;
                }
                tab[index] = newFirst;
                this.count = c;
            }
            return oldValue;
        }

        final void locklessClear() {
            if (this.count != 0) {
                HashEntry[] tab = this.table;
                for (int i = 0; i < tab.length; ++i) {
                    tab[i] = null;
                }
                this.count = 0;
            }
        }
    }

    static final class HashEntry {
        final Object key;
        final int hash;
        volatile LinkedEntry value;
        final HashEntry next;

        HashEntry(Object key, int hash, HashEntry next, LinkedEntry value) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.value = value;
        }
    }

    static final class Marker
    extends LinkedEntry {
        Marker(LinkedEntry actual) {
            super(null);
            this.n = actual;
            this.p = actual;
        }
    }

    static class LinkedEntry {
        volatile InternalCacheEntry e;
        volatile LinkedEntry n;
        volatile LinkedEntry p;
        private static final AtomicReferenceFieldUpdater<LinkedEntry, LinkedEntry> N_UPDATER = AtomicReferenceFieldUpdater.newUpdater(LinkedEntry.class, LinkedEntry.class, "n");
        private static final AtomicReferenceFieldUpdater<LinkedEntry, LinkedEntry> P_UPDATER = AtomicReferenceFieldUpdater.newUpdater(LinkedEntry.class, LinkedEntry.class, "p");

        LinkedEntry(InternalCacheEntry e) {
            this.e = e;
        }

        final boolean casNext(LinkedEntry expected, LinkedEntry newValue) {
            return N_UPDATER.compareAndSet(this, expected, newValue);
        }

        final boolean casPrev(LinkedEntry expected, LinkedEntry newValue) {
            return P_UPDATER.compareAndSet(this, expected, newValue);
        }
    }
}

