/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.util.StringPropertyReplacer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlParserBase {
    protected int getInt(String intStr) {
        return Integer.parseInt(intStr);
    }

    protected long getLong(String longStr) {
        return Long.parseLong(longStr);
    }

    protected boolean getBoolean(String str) {
        return str == null ? false : Boolean.valueOf(str);
    }

    protected boolean existsAttribute(String attrValue) {
        return attrValue != null && attrValue.length() > 0;
    }

    protected Element getSingleElement(String namespace, String elementName, Element parent) {
        NodeList nodeList = parent.getElementsByTagNameNS(namespace, elementName);
        if (nodeList.getLength() == 0 && (nodeList = parent.getElementsByTagName(elementName)).getLength() == 0) {
            return null;
        }
        return (Element)nodeList.item(0);
    }

    protected Set<Element> getAllElements(String namespace, String elementName, Element parent) {
        NodeList nodeList = parent.getElementsByTagNameNS(namespace, elementName);
        if (nodeList.getLength() == 0) {
            return Collections.emptySet();
        }
        HashSet<Element> elements = new HashSet<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (!(n instanceof Element)) continue;
            elements.add((Element)n);
        }
        return elements;
    }

    protected Element getSingleElementInCoreNS(String elementName, Element parent) {
        return this.getSingleElement("urn:infinispan:config:4.0", elementName, parent);
    }

    protected Set<Element> getAllElementsInCoreNS(String elementName, Element parent) {
        return this.getAllElements("urn:infinispan:config:4.0", elementName, parent);
    }

    protected String getAttributeValue(Element element, String attrName) {
        if (element == null || attrName == null) {
            return null;
        }
        String value = element.getAttribute(attrName);
        return value == null ? null : StringPropertyReplacer.replaceProperties((String)value);
    }
}

