/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.Properties;
import org.infinispan.CacheException;
import org.infinispan.Version;
import org.infinispan.config.AbstractConfigurationBean;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.executors.DefaultExecutorFactory;
import org.infinispan.executors.DefaultScheduledExecutorFactory;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.NonVolatile;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.PlatformMBeanServerLookup;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.marshall.VersionAwareMarshaller;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.util.TypedProperties;

@NonVolatile
@Scope(value=Scopes.GLOBAL)
public class GlobalConfiguration
extends AbstractConfigurationBean {
    public static final short DEFAULT_MARSHALL_VERSION = Version.getVersionShort();
    private String asyncListenerExecutorFactoryClass = DefaultExecutorFactory.class.getName();
    private TypedProperties asyncListenerExecutorProperties = EMPTY_PROPERTIES;
    private String asyncTransportExecutorFactoryClass = DefaultExecutorFactory.class.getName();
    private TypedProperties asyncTransportExecutorProperties = EMPTY_PROPERTIES;
    private String evictionScheduledExecutorFactoryClass = DefaultScheduledExecutorFactory.class.getName();
    private TypedProperties evictionScheduledExecutorProperties = EMPTY_PROPERTIES;
    private String replicationQueueScheduledExecutorFactoryClass = DefaultScheduledExecutorFactory.class.getName();
    private TypedProperties replicationQueueScheduledExecutorProperties = EMPTY_PROPERTIES;
    private String marshallerClass = VersionAwareMarshaller.class.getName();
    private String transportClass = null;
    private TypedProperties transportProperties = EMPTY_PROPERTIES;
    private Configuration defaultConfiguration;
    private String clusterName = "Infinispan-Cluster";
    private ShutdownHookBehavior shutdownHookBehavior = ShutdownHookBehavior.DEFAULT;
    private short marshallVersion = DEFAULT_MARSHALL_VERSION;
    private GlobalComponentRegistry gcr;
    private long distributedSyncTimeout = 60000L;
    private boolean exposeGlobalJmxStatistics = false;
    private String jmxDomain = "infinispan";
    private String mBeanServerLookup = PlatformMBeanServerLookup.class.getName();
    private boolean allowDuplicateDomains = false;

    public boolean isExposeGlobalJmxStatistics() {
        return this.exposeGlobalJmxStatistics;
    }

    public void setExposeGlobalJmxStatistics(boolean exposeGlobalJmxStatistics) {
        this.testImmutability("exposeGlobalManagementStatistics");
        this.exposeGlobalJmxStatistics = exposeGlobalJmxStatistics;
    }

    public void setJmxDomain(String jmxObjectName) {
        this.testImmutability("jmxNameBase");
        this.jmxDomain = jmxObjectName;
    }

    public String getJmxDomain() {
        return this.jmxDomain;
    }

    public String getMBeanServerLookup() {
        return this.mBeanServerLookup;
    }

    public void setMBeanServerLookup(String mBeanServerLookup) {
        this.testImmutability("mBeanServerLookup");
        this.mBeanServerLookup = mBeanServerLookup;
    }

    public boolean isAllowDuplicateDomains() {
        return this.allowDuplicateDomains;
    }

    public void setAllowDuplicateDomains(boolean allowDuplicateDomains) {
        this.testImmutability("allowDuplicateDomains");
        this.allowDuplicateDomains = allowDuplicateDomains;
    }

    @Inject
    private void injectDependencies(GlobalComponentRegistry gcr) {
        this.gcr = gcr;
    }

    protected boolean hasComponentStarted() {
        return this.gcr != null && this.gcr.getStatus() != null && this.gcr.getStatus() == ComponentStatus.RUNNING;
    }

    public String getAsyncListenerExecutorFactoryClass() {
        return this.asyncListenerExecutorFactoryClass;
    }

    public void setAsyncListenerExecutorFactoryClass(String asyncListenerExecutorFactoryClass) {
        this.testImmutability("asyncListenerExecutorFactoryClass");
        this.asyncListenerExecutorFactoryClass = asyncListenerExecutorFactoryClass;
    }

    public String getAsyncTransportExecutorFactoryClass() {
        return this.asyncTransportExecutorFactoryClass;
    }

    public void setAsyncTransportExecutorFactoryClass(String asyncTransportExecutorFactoryClass) {
        this.testImmutability("asyncTransportExecutorFactoryClass");
        this.asyncTransportExecutorFactoryClass = asyncTransportExecutorFactoryClass;
    }

    public String getEvictionScheduledExecutorFactoryClass() {
        return this.evictionScheduledExecutorFactoryClass;
    }

    public void setEvictionScheduledExecutorFactoryClass(String evictionScheduledExecutorFactoryClass) {
        this.testImmutability("evictionScheduledExecutorFactoryClass");
        this.evictionScheduledExecutorFactoryClass = evictionScheduledExecutorFactoryClass;
    }

    public String getReplicationQueueScheduledExecutorFactoryClass() {
        return this.replicationQueueScheduledExecutorFactoryClass;
    }

    public void setReplicationQueueScheduledExecutorFactoryClass(String replicationQueueScheduledExecutorFactoryClass) {
        this.testImmutability("replicationQueueScheduledExecutorFactoryClass");
        this.replicationQueueScheduledExecutorFactoryClass = replicationQueueScheduledExecutorFactoryClass;
    }

    public String getMarshallerClass() {
        return this.marshallerClass;
    }

    public void setMarshallerClass(String marshallerClass) {
        this.testImmutability("marshallerClass");
        this.marshallerClass = marshallerClass;
    }

    public String getTransportClass() {
        return this.transportClass;
    }

    public void setTransportClass(String transportClass) {
        this.testImmutability("transportClass");
        this.transportClass = transportClass;
    }

    public Properties getTransportProperties() {
        return this.transportProperties;
    }

    public void setTransportProperties(Properties transportProperties) {
        this.testImmutability("transportProperties");
        this.transportProperties = this.toTypedProperties(transportProperties);
    }

    public void setTransportProperties(String transportPropertiesString) {
        this.testImmutability("transportProperties");
        this.transportProperties = this.toTypedProperties(transportPropertiesString);
    }

    public Configuration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public void setDefaultConfiguration(Configuration defaultConfiguration) {
        this.testImmutability("defaultConfiguration");
        this.defaultConfiguration = defaultConfiguration;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.testImmutability("clusterName");
        this.clusterName = clusterName;
    }

    public ShutdownHookBehavior getShutdownHookBehavior() {
        return this.shutdownHookBehavior;
    }

    public void setShutdownHookBehavior(ShutdownHookBehavior shutdownHookBehavior) {
        this.testImmutability("shutdownHookBehavior");
        this.shutdownHookBehavior = shutdownHookBehavior;
    }

    public void setShutdownHookBehavior(String shutdownHookBehavior) {
        if (shutdownHookBehavior == null) {
            throw new ConfigurationException("Shutdown hook behavior cannot be null", "ShutdownHookBehavior");
        }
        ShutdownHookBehavior temp = ShutdownHookBehavior.valueOf(this.uc(shutdownHookBehavior));
        if (temp == null) {
            this.log.warn("Unknown shutdown hook behavior '" + shutdownHookBehavior + "', using defaults.");
            temp = ShutdownHookBehavior.DEFAULT;
        }
        this.setShutdownHookBehavior(temp);
    }

    public Properties getAsyncListenerExecutorProperties() {
        return this.asyncListenerExecutorProperties;
    }

    public void setAsyncListenerExecutorProperties(Properties asyncListenerExecutorProperties) {
        this.testImmutability("asyncListenerExecutorProperties");
        this.asyncListenerExecutorProperties = this.toTypedProperties(asyncListenerExecutorProperties);
    }

    public void setAsyncListenerExecutorProperties(String asyncListenerExecutorPropertiesString) {
        this.testImmutability("asyncListenerExecutorProperties");
        this.asyncListenerExecutorProperties = this.toTypedProperties(asyncListenerExecutorPropertiesString);
    }

    public Properties getAsyncTransportExecutorProperties() {
        return this.asyncTransportExecutorProperties;
    }

    public void setAsyncTransportExecutorProperties(Properties asyncTransportExecutorProperties) {
        this.testImmutability("asyncTransportExecutorProperties");
        this.asyncTransportExecutorProperties = this.toTypedProperties(asyncTransportExecutorProperties);
    }

    public void setAsyncTransportExecutorProperties(String asyncSerializationExecutorPropertiesString) {
        this.testImmutability("asyncTransportExecutorProperties");
        this.asyncTransportExecutorProperties = this.toTypedProperties(asyncSerializationExecutorPropertiesString);
    }

    public Properties getEvictionScheduledExecutorProperties() {
        return this.evictionScheduledExecutorProperties;
    }

    public void setEvictionScheduledExecutorProperties(Properties evictionScheduledExecutorProperties) {
        this.testImmutability("evictionScheduledExecutorProperties");
        this.evictionScheduledExecutorProperties = this.toTypedProperties(evictionScheduledExecutorProperties);
    }

    public void setEvictionScheduledExecutorProperties(String evictionScheduledExecutorPropertiesString) {
        this.testImmutability("evictionScheduledExecutorProperties");
        this.evictionScheduledExecutorProperties = this.toTypedProperties(evictionScheduledExecutorPropertiesString);
    }

    public Properties getReplicationQueueScheduledExecutorProperties() {
        return this.replicationQueueScheduledExecutorProperties;
    }

    public void setReplicationQueueScheduledExecutorProperties(Properties replicationQueueScheduledExecutorProperties) {
        this.testImmutability("replicationQueueScheduledExecutorProperties");
        this.replicationQueueScheduledExecutorProperties = this.toTypedProperties(replicationQueueScheduledExecutorProperties);
    }

    public void setReplicationQueueScheduledExecutorProperties(String replicationQueueScheduledExecutorPropertiesString) {
        this.testImmutability("replicationQueueScheduledExecutorProperties");
        this.replicationQueueScheduledExecutorProperties = this.toTypedProperties(replicationQueueScheduledExecutorPropertiesString);
    }

    public short getMarshallVersion() {
        return this.marshallVersion;
    }

    public String getMarshallVersionString() {
        return Version.decodeVersionForSerialization(this.marshallVersion);
    }

    public void setMarshallVersion(short marshallVersion) {
        this.testImmutability("marshallVersion");
        this.marshallVersion = marshallVersion;
    }

    public void setMarshallVersion(String marshallVersion) {
        this.testImmutability("marshallVersion");
        this.marshallVersion = Version.getVersionShort(marshallVersion);
    }

    public long getDistributedSyncTimeout() {
        return this.distributedSyncTimeout;
    }

    public void setDistributedSyncTimeout(long distributedSyncTimeout) {
        this.testImmutability("distributedSyncTimeout");
        this.distributedSyncTimeout = distributedSyncTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalConfiguration that = (GlobalConfiguration)o;
        if (this.marshallVersion != that.marshallVersion) {
            return false;
        }
        if (this.asyncListenerExecutorFactoryClass != null ? !this.asyncListenerExecutorFactoryClass.equals(that.asyncListenerExecutorFactoryClass) : that.asyncListenerExecutorFactoryClass != null) {
            return false;
        }
        if (this.asyncListenerExecutorProperties != null ? !this.asyncListenerExecutorProperties.equals(that.asyncListenerExecutorProperties) : that.asyncListenerExecutorProperties != null) {
            return false;
        }
        if (this.asyncTransportExecutorFactoryClass != null ? !this.asyncTransportExecutorFactoryClass.equals(that.asyncTransportExecutorFactoryClass) : that.asyncTransportExecutorFactoryClass != null) {
            return false;
        }
        if (this.asyncTransportExecutorProperties != null ? !this.asyncTransportExecutorProperties.equals(that.asyncTransportExecutorProperties) : that.asyncTransportExecutorProperties != null) {
            return false;
        }
        if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
            return false;
        }
        if (this.defaultConfiguration != null ? !this.defaultConfiguration.equals(that.defaultConfiguration) : that.defaultConfiguration != null) {
            return false;
        }
        if (this.evictionScheduledExecutorFactoryClass != null ? !this.evictionScheduledExecutorFactoryClass.equals(that.evictionScheduledExecutorFactoryClass) : that.evictionScheduledExecutorFactoryClass != null) {
            return false;
        }
        if (this.evictionScheduledExecutorProperties != null ? !this.evictionScheduledExecutorProperties.equals(that.evictionScheduledExecutorProperties) : that.evictionScheduledExecutorProperties != null) {
            return false;
        }
        if (this.marshallerClass != null ? !this.marshallerClass.equals(that.marshallerClass) : that.marshallerClass != null) {
            return false;
        }
        if (this.replicationQueueScheduledExecutorFactoryClass != null ? !this.replicationQueueScheduledExecutorFactoryClass.equals(that.replicationQueueScheduledExecutorFactoryClass) : that.replicationQueueScheduledExecutorFactoryClass != null) {
            return false;
        }
        if (this.replicationQueueScheduledExecutorProperties != null ? !this.replicationQueueScheduledExecutorProperties.equals(that.replicationQueueScheduledExecutorProperties) : that.replicationQueueScheduledExecutorProperties != null) {
            return false;
        }
        if (this.shutdownHookBehavior != that.shutdownHookBehavior) {
            return false;
        }
        if (this.transportClass != null ? !this.transportClass.equals(that.transportClass) : that.transportClass != null) {
            return false;
        }
        if (this.transportProperties != null ? !this.transportProperties.equals(that.transportProperties) : that.transportProperties != null) {
            return false;
        }
        return this.distributedSyncTimeout == that.distributedSyncTimeout;
    }

    public int hashCode() {
        int result = this.asyncListenerExecutorFactoryClass != null ? this.asyncListenerExecutorFactoryClass.hashCode() : 0;
        result = 31 * result + (this.asyncListenerExecutorProperties != null ? this.asyncListenerExecutorProperties.hashCode() : 0);
        result = 31 * result + (this.asyncTransportExecutorFactoryClass != null ? this.asyncTransportExecutorFactoryClass.hashCode() : 0);
        result = 31 * result + (this.asyncTransportExecutorProperties != null ? this.asyncTransportExecutorProperties.hashCode() : 0);
        result = 31 * result + (this.evictionScheduledExecutorFactoryClass != null ? this.evictionScheduledExecutorFactoryClass.hashCode() : 0);
        result = 31 * result + (this.evictionScheduledExecutorProperties != null ? this.evictionScheduledExecutorProperties.hashCode() : 0);
        result = 31 * result + (this.replicationQueueScheduledExecutorFactoryClass != null ? this.replicationQueueScheduledExecutorFactoryClass.hashCode() : 0);
        result = 31 * result + (this.replicationQueueScheduledExecutorProperties != null ? this.replicationQueueScheduledExecutorProperties.hashCode() : 0);
        result = 31 * result + (this.marshallerClass != null ? this.marshallerClass.hashCode() : 0);
        result = 31 * result + (this.transportClass != null ? this.transportClass.hashCode() : 0);
        result = 31 * result + (this.transportProperties != null ? this.transportProperties.hashCode() : 0);
        result = 31 * result + (this.defaultConfiguration != null ? this.defaultConfiguration.hashCode() : 0);
        result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
        result = 31 * result + (this.shutdownHookBehavior != null ? this.shutdownHookBehavior.hashCode() : 0);
        result = 31 * result + this.marshallVersion;
        result = (int)((long)(31 * result) + this.distributedSyncTimeout);
        return result;
    }

    public GlobalConfiguration clone() {
        try {
            return (GlobalConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException("Problems cloning configuration component!", e);
        }
    }

    public static GlobalConfiguration getClusteredDefault() {
        GlobalConfiguration gc = new GlobalConfiguration();
        gc.setTransportClass(JGroupsTransport.class.getName());
        gc.setTransportProperties((Properties)null);
        Properties p = new Properties();
        p.setProperty("threadNamePrefix", "asyncTransportThread");
        gc.setAsyncTransportExecutorProperties(p);
        return gc;
    }

    public static GlobalConfiguration getNonClusteredDefault() {
        GlobalConfiguration gc = new GlobalConfiguration();
        gc.setTransportClass(null);
        gc.setTransportProperties((Properties)null);
        return gc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShutdownHookBehavior {
        DEFAULT,
        REGISTER,
        DONT_REGISTER;

    }
}

