/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteredGetCommand
implements CacheRpcCommand {
    public static final byte COMMAND_ID = 16;
    private static final Log log = LogFactory.getLog(ClusteredGetCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private Object key;
    private String cacheName;
    private DataContainer dataContainer;
    private InvocationContextContainer icc;
    private CommandsFactory commandsFactory;
    private InterceptorChain invoker;

    public ClusteredGetCommand() {
    }

    public ClusteredGetCommand(Object key, String cacheName) {
        this.key = key;
        this.cacheName = cacheName;
    }

    public void initialize(DataContainer dataContainer, InvocationContextContainer icc, CommandsFactory commandsFactory, InterceptorChain interceptorChain) {
        this.dataContainer = dataContainer;
        this.icc = icc;
        this.commandsFactory = commandsFactory;
        this.invoker = interceptorChain;
    }

    public InternalCacheValue perform(InvocationContext context) throws Throwable {
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(this.key);
        command.setReturnCacheEntry(true);
        NonTxInvocationContext invocationContext = this.icc.createRemoteInvocationContext();
        CacheEntry cacheEntry = (CacheEntry)this.invoker.invoke(invocationContext, command);
        if (cacheEntry == null) {
            if (trace) {
                log.trace("Did not find anything, returning null");
            }
            return null;
        }
        if (cacheEntry instanceof MVCCEntry) {
            if (trace) {
                log.trace("Handloing an internal cache entry...");
            }
            MVCCEntry mvccEntry = (MVCCEntry)cacheEntry;
            return InternalEntryFactory.createValue(mvccEntry.getValue(), -1L, mvccEntry.getLifespan(), -1L, mvccEntry.getMaxIdle());
        }
        InternalCacheEntry internalCacheEntry = (InternalCacheEntry)cacheEntry;
        return internalCacheEntry.toInternalCacheValue();
    }

    public byte getCommandId() {
        return 16;
    }

    public Object[] getParameters() {
        return new Object[]{this.key, this.cacheName};
    }

    public void setParameters(int commandId, Object[] args) {
        this.key = args[0];
        this.cacheName = (String)args[1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusteredGetCommand that = (ClusteredGetCommand)o;
        return !(this.key == null ? that.key != null : !this.key.equals(that.key));
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        return result;
    }

    public String toString() {
        return "ClusteredGetCommand{key=" + this.key + ", dataContainer=" + this.dataContainer + '}';
    }

    public String getCacheName() {
        return this.cacheName;
    }
}

