/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.infinispan.atomic.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutOperation<K, V>
extends Operation<K, V> {
    private K key;
    private V oldValue;
    private V newValue;

    public PutOperation() {
    }

    PutOperation(K key, V oldValue, V newValue) {
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public void rollback(Map<K, V> delegate) {
        if (this.oldValue == null) {
            delegate.remove(this.key);
        } else {
            delegate.put(this.key, this.oldValue);
        }
    }

    @Override
    public void replay(Map<K, V> delegate) {
        delegate.put(this.key, this.newValue);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.key);
        out.writeObject(this.newValue);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.key = in.readObject();
        this.newValue = in.readObject();
    }
}

