/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.CacheException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    private static final Log log = LogFactory.getLog(ReflectionUtil.class);

    public static List<Method> getAllMethods(Class c, Class<? extends Annotation> annotationType) {
        LinkedList<Method> annotated = new LinkedList<Method>();
        ReflectionUtil.inspectRecursively(c, annotated, annotationType);
        return annotated;
    }

    private static void inspectRecursively(Class c, List<Method> s, Class<? extends Annotation> annotationType) {
        if (!c.equals(Object.class) && !c.isInterface()) {
            ReflectionUtil.inspectRecursively(c.getSuperclass(), s, annotationType);
            for (GenericDeclaration genericDeclaration : c.getInterfaces()) {
                ReflectionUtil.inspectRecursively((Class)genericDeclaration, s, annotationType);
            }
        }
        for (GenericDeclaration genericDeclaration : c.getDeclaredMethods()) {
            if (ReflectionUtil.alreadyFound((Method)genericDeclaration, s) || !((AccessibleObject)((Object)genericDeclaration)).isAnnotationPresent(annotationType)) continue;
            s.add((Method)genericDeclaration);
        }
    }

    private static boolean alreadyFound(Method m, Collection<Method> s) {
        for (Method found : s) {
            if (!m.getName().equals(found.getName()) || !Arrays.equals(m.getParameterTypes(), found.getParameterTypes())) continue;
            return true;
        }
        return false;
    }

    public static void setValue(Object instance, String fieldName, Object value) {
        try {
            Field f = ReflectionUtil.findFieldRecursively(instance.getClass(), fieldName);
            if (f == null) {
                throw new NoSuchMethodException("Cannot find field " + fieldName + " on " + instance.getClass() + " or superclasses");
            }
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (Exception e) {
            log.error((Object)"Unable to set value!", e);
        }
    }

    private static Field findFieldRecursively(Class c, String fieldName) {
        Field f;
        block2: {
            f = null;
            try {
                f = c.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                if (c.equals(Object.class)) break block2;
                f = ReflectionUtil.findFieldRecursively(c.getSuperclass(), fieldName);
            }
        }
        return f;
    }

    public static void invokeAccessibly(Object instance, Method method, Object[] parameters) {
        try {
            method.setAccessible(true);
            method.invoke(instance, parameters);
        }
        catch (Exception e) {
            throw new CacheException("Unable to invoke method " + method + " on object " + (parameters != null ? " with parameters " + Arrays.asList(parameters) : ""), e);
        }
    }

    public static Object getValue(Object instance, String fieldName) {
        Field f = ReflectionUtil.findFieldRecursively(instance.getClass(), fieldName);
        if (f == null) {
            throw new CacheException("Could not find field named: " + fieldName + " on instance :" + instance);
        }
        try {
            f.setAccessible(true);
            return f.get(instance);
        }
        catch (IllegalAccessException iae) {
            throw new CacheException("Cannot access field " + f, iae);
        }
    }

    public static <T extends Annotation> T getAnnotation(Class clazz, Class<T> ann) {
        Class superclass;
        T a = clazz.getAnnotation(ann);
        if (a != null) {
            return a;
        }
        if (!clazz.isInterface()) {
            Class<?>[] interfaces;
            for (Class<?> inter : interfaces = clazz.getInterfaces()) {
                a = ReflectionUtil.getAnnotation(inter, ann);
                if (a == null) continue;
                return a;
            }
        }
        if ((superclass = clazz.getSuperclass()) == null) {
            return null;
        }
        return ReflectionUtil.getAnnotation(superclass, ann);
    }

    public static boolean isAnnotationPresent(Class clazz, Class<? extends Annotation> annotation) {
        return ReflectionUtil.getAnnotation(clazz, annotation) != null;
    }
}

