/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.remoting.transport.Address;

public class GlobalTransaction
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 8011434781266976149L;
    private static AtomicLong sid = new AtomicLong(0L);
    private long id = -1L;
    private transient Address addr = null;
    private transient int hash_code = -1;
    private transient boolean remote = false;

    public GlobalTransaction() {
    }

    public GlobalTransaction(Address addr, boolean remote) {
        this.id = sid.incrementAndGet();
        this.addr = addr;
        this.remote = remote;
    }

    public GlobalTransaction(long id, Address addr) {
        this.id = id;
        this.addr = addr;
        this.remote = true;
    }

    public GlobalTransaction(boolean remote) {
        this(null, remote);
    }

    public Object getAddress() {
        return this.addr;
    }

    public long getId() {
        return this.id;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeObject(this.addr);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.addr = (Address)in.readObject();
        this.hash_code = -1;
    }

    public int hashCode() {
        if (this.hash_code == -1) {
            this.hash_code = (this.addr != null ? this.addr.hashCode() : 0) + (int)this.id;
        }
        return this.hash_code;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GlobalTransaction)) {
            return false;
        }
        GlobalTransaction otherGtx = (GlobalTransaction)other;
        boolean aeq = this.addr == null ? otherGtx.addr == null : this.addr.equals(otherGtx.addr);
        return aeq && this.id == otherGtx.id;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GlobalTransaction:<").append(this.addr).append(">:").append(this.id);
        return sb.toString();
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setAddress(Address address) {
        this.addr = address;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!");
        }
    }
}

