/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.NotSerializableException;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.CacheException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.remoting.InboundInvocationHandler;
import org.infinispan.remoting.responses.ExtendedResponse;
import org.infinispan.remoting.responses.RequestIgnoredResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.DistributedSync;
import org.infinispan.remoting.transport.jgroups.JGroupsDistSync;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Buffer;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandAwareRpcDispatcher
extends RpcDispatcher {
    protected boolean trace;
    ExecutorService asyncExecutor;
    InboundInvocationHandler inboundInvocationHandler;
    JGroupsDistSync distributedSync;
    long distributedSyncTimeout;
    private Log log = LogFactory.getLog(CommandAwareRpcDispatcher.class);
    AtomicBoolean newCacheStarting = new AtomicBoolean(false);
    AtomicBoolean newCacheStarted = new AtomicBoolean(false);

    public CommandAwareRpcDispatcher() {
    }

    public CommandAwareRpcDispatcher(Channel channel, JGroupsTransport transport, ExecutorService asyncExecutor, InboundInvocationHandler inboundInvocationHandler, JGroupsDistSync distributedSync, long distributedSyncTimeout) {
        super(channel, (MessageListener)transport, (MembershipListener)transport, (Object)transport);
        this.asyncExecutor = asyncExecutor;
        this.inboundInvocationHandler = inboundInvocationHandler;
        this.distributedSync = distributedSync;
        this.trace = this.log.isTraceEnabled();
        this.distributedSyncTimeout = distributedSyncTimeout;
    }

    protected final boolean isValid(Message req) {
        if (req == null || req.getLength() == 0) {
            this.log.error("message or message buffer is null");
            return false;
        }
        return true;
    }

    public RspList invokeRemoteCommands(Vector<Address> dests, ReplicableCommand command, int mode, long timeout, boolean anycasting, boolean oob, RspFilter filter, boolean supportReplay, boolean asyncMarshalling) throws NotSerializableException, ExecutionException, InterruptedException {
        RspList response;
        ReplicationTask task = new ReplicationTask(command, oob, dests, mode, timeout, anycasting, filter, supportReplay);
        if (asyncMarshalling) {
            this.asyncExecutor.submit(task);
            return null;
        }
        try {
            response = task.call();
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        if (response.isEmpty() || this.containsOnlyNulls(response)) {
            return null;
        }
        return response;
    }

    private boolean containsOnlyNulls(RspList l) {
        for (Rsp r : l.values()) {
            if (r.getValue() == null && r.wasReceived() && !r.wasSuspected()) continue;
            return false;
        }
        return true;
    }

    public Object handle(Message req) {
        if (this.isValid(req)) {
            try {
                ReplicableCommand cmd = (ReplicableCommand)this.req_marshaller.objectFromByteBuffer(req.getBuffer(), req.getOffset(), req.getLength());
                if (cmd instanceof CacheRpcCommand) {
                    return this.executeCommand((CacheRpcCommand)cmd, req);
                }
                return cmd.perform(null);
            }
            catch (Throwable x) {
                if (this.trace) {
                    this.log.trace((Object)"Problems invoking command.", x);
                }
                return x;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response executeCommand(CacheRpcCommand cmd, Message req) throws Throwable {
        if (cmd == null) {
            throw new NullPointerException("Unable to execute a null command!  Message was " + req);
        }
        if (this.trace) {
            this.log.trace((Object)"Attempting to execute command: {0} [sender={1}]", cmd, req.getSrc());
        }
        boolean unlock = false;
        try {
            Response resp;
            boolean replayIgnored;
            this.distributedSync.acquireProcessingLock(false, this.distributedSyncTimeout, TimeUnit.MILLISECONDS);
            unlock = true;
            DistributedSync.SyncResponse sr = this.distributedSync.blockUntilReleased(this.distributedSyncTimeout, TimeUnit.MILLISECONDS);
            boolean bl = replayIgnored = sr == DistributedSync.SyncResponse.STATE_ACHIEVED;
            if (this.trace) {
                this.log.trace((Object)"Enough waiting; replayIgnored = {0}, sr {1}", new Object[]{replayIgnored, sr});
            }
            if ((resp = this.inboundInvocationHandler.handle(cmd)) == null || resp.isValid()) {
                if (replayIgnored) {
                    resp = new ExtendedResponse(resp, true);
                }
            } else {
                this.newCacheStarting.set(true);
                if (this.trace) {
                    this.log.trace("Unable to execute command, got invalid response");
                }
            }
            Response response = resp;
            return response;
        }
        finally {
            if (unlock) {
                this.distributedSync.releaseProcessingLock();
            }
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[Outgoing marshaller: " + this.req_marshaller + "; incoming marshaller: " + this.rsp_marshaller + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReplicationTask
    implements Callable<RspList> {
        private ReplicableCommand command;
        private boolean oob;
        private Vector<Address> dests;
        private int mode;
        private long timeout;
        private boolean anycasting;
        private RspFilter filter;
        boolean supportReplay = false;

        private ReplicationTask(ReplicableCommand command, boolean oob, Vector<Address> dests, int mode, long timeout, boolean anycasting, RspFilter filter, boolean supportReplay) {
            this.command = command;
            this.oob = oob;
            this.dests = dests;
            this.mode = mode;
            this.timeout = timeout;
            this.anycasting = anycasting;
            this.filter = filter;
            this.supportReplay = supportReplay;
        }

        @Override
        public RspList call() throws Exception {
            Buffer buf;
            try {
                buf = CommandAwareRpcDispatcher.this.req_marshaller.objectToBuffer((Object)this.command);
            }
            catch (Exception e) {
                throw new RuntimeException("Failure to marshal argument(s)", e);
            }
            Message msg = new Message();
            msg.setBuffer(buf);
            if (this.oob) {
                msg.setFlag((byte)1);
            }
            int mode = this.supportReplay ? 2 : this.mode;
            CommandAwareRpcDispatcher.this.distributedSync.blockUntilNoJoinsInProgress();
            RspList retval = CommandAwareRpcDispatcher.this.castMessage(this.dests, msg, mode, this.timeout, this.anycasting, this.filter);
            if (CommandAwareRpcDispatcher.this.trace) {
                CommandAwareRpcDispatcher.this.log.trace((Object)"responses: {0}", retval);
            }
            if (retval == null) {
                throw new NotSerializableException("RpcDispatcher returned a null.  This is most often caused by args for " + this.command.getClass().getSimpleName() + " not being serializable.");
            }
            if (this.supportReplay) {
                boolean replay = false;
                Vector ignorers = new Vector();
                for (Map.Entry entry : retval.entrySet()) {
                    Object value = ((Rsp)entry.getValue()).getValue();
                    if (value instanceof RequestIgnoredResponse) {
                        ignorers.add(entry.getKey());
                        continue;
                    }
                    if (!(value instanceof ExtendedResponse)) continue;
                    ExtendedResponse extended = (ExtendedResponse)value;
                    replay |= extended.isReplayIgnoredRequests();
                    ((Rsp)entry.getValue()).setValue((Object)extended.getResponse());
                }
                if (replay && ignorers.size() > 0) {
                    RspList responses;
                    if (CommandAwareRpcDispatcher.this.trace) {
                        CommandAwareRpcDispatcher.this.log.trace("Replaying message to ignoring senders: " + ignorers);
                    }
                    if ((responses = CommandAwareRpcDispatcher.this.castMessage(ignorers, msg, 2, this.timeout, this.anycasting, this.filter)) != null) {
                        retval.putAll((Map)responses);
                    }
                }
            }
            return retval;
        }
    }
}

