/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.rpc;

import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.config.Configuration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.remoting.ReplicationException;
import org.infinispan.remoting.ReplicationQueue;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.statetransfer.StateTransferException;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(objectName="RpcManager")
public class RpcManagerImpl
implements RpcManager {
    private static final Log log = LogFactory.getLog(RpcManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private Transport t;
    private final AtomicLong replicationCount = new AtomicLong(0L);
    private final AtomicLong replicationFailures = new AtomicLong(0L);
    boolean statisticsEnabled = false;
    private volatile Address currentStateTransferSource;
    private boolean stateTransferEnabled;
    private Configuration configuration;
    private ReplicationQueue replicationQueue;
    private ExecutorService asyncExecutor;
    private CommandsFactory cf;

    @Inject
    public void injectDependencies(Transport t, Configuration configuration, ReplicationQueue replicationQueue, CommandsFactory cf, @ComponentName(value="org.infinispan.executors.transport") ExecutorService e) {
        this.t = t;
        this.configuration = configuration;
        this.replicationQueue = replicationQueue;
        this.asyncExecutor = e;
        this.cf = cf;
    }

    @Start(priority=9)
    private void start() {
        this.stateTransferEnabled = this.configuration.isStateTransferEnabled();
    }

    private boolean useReplicationQueue(boolean sync) {
        return !sync && this.replicationQueue != null && this.replicationQueue.isEnabled();
    }

    @Override
    public final List<Response> invokeRemotely(List<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter) throws Exception {
        List<Address> members = this.t.getMembers();
        if (members.size() < 2) {
            if (log.isDebugEnabled()) {
                log.debug("We're the only member in the cluster; Don't invoke remotely.");
            }
            return Collections.emptyList();
        }
        try {
            List<Response> result = this.t.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue, responseFilter, this.stateTransferEnabled);
            if (this.isStatisticsEnabled()) {
                this.replicationCount.incrementAndGet();
            }
            return result;
        }
        catch (CacheException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"replication exception: ", e);
            }
            if (this.isStatisticsEnabled()) {
                this.replicationFailures.incrementAndGet();
            }
            throw e;
        }
        catch (Throwable th) {
            log.error((Object)"unexpected error while replicating", th);
            if (this.isStatisticsEnabled()) {
                this.replicationFailures.incrementAndGet();
            }
            throw new CacheException(th);
        }
    }

    @Override
    public final List<Response> invokeRemotely(List<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue) throws Exception {
        return this.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue, null);
    }

    @Override
    public final List<Response> invokeRemotely(List<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout) throws Exception {
        return this.invokeRemotely(recipients, rpcCommand, mode, timeout, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retrieveState(String cacheName, long timeout) throws StateTransferException {
        if (this.t.isSupportStateTransfer()) {
            boolean success;
            block20: {
                Random r = new Random();
                int initialWaitTime = (r.nextInt(10) + 1) * 100;
                int waitTimeIncreaseFactor = 2;
                int numRetries = 5;
                List<Address> members = this.t.getMembers();
                if (members.size() < 2) {
                    if (log.isDebugEnabled()) {
                        log.debug("We're the only member in the cluster; no one to retrieve state from. Not doing anything!");
                    }
                    return;
                }
                success = false;
                try {
                    int wait = initialWaitTime;
                    for (int i = 0; i < numRetries; ++i) {
                        for (Address member : members) {
                            if (member.equals(this.t.getAddress())) continue;
                            try {
                                if (log.isInfoEnabled()) {
                                    log.info((Object)"Trying to fetch state from {0}", member);
                                }
                                this.currentStateTransferSource = member;
                                if (!this.t.retrieveState(cacheName, member, timeout)) continue;
                                if (log.isInfoEnabled()) {
                                    log.info((Object)"Successfully retrieved and applied state from {0}", member);
                                }
                                success = true;
                                break block20;
                            }
                            catch (StateTransferException e) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)("Error while fetching state from member " + member), e);
                            }
                            finally {
                                this.currentStateTransferSource = null;
                            }
                        }
                        if (success) continue;
                        if (log.isWarnEnabled()) {
                            log.warn("Could not find available peer for state, backing off and retrying");
                        }
                        try {
                            Thread.sleep(wait *= waitTimeIncreaseFactor);
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                finally {
                    this.currentStateTransferSource = null;
                }
            }
            if (!success) {
                throw new StateTransferException("Unable to fetch state on startup");
            }
        } else {
            throw new StateTransferException("Transport does not, or is not configured to, support state transfer.  Please disable fetching state on startup, or reconfigure your transport.");
        }
    }

    @Override
    public final void broadcastRpcCommand(ReplicableCommand rpc, boolean sync) throws ReplicationException {
        this.broadcastRpcCommand(rpc, sync, false);
    }

    @Override
    public final void broadcastRpcCommand(ReplicableCommand rpc, boolean sync, boolean usePriorityQueue) throws ReplicationException {
        if (this.useReplicationQueue(sync)) {
            this.replicationQueue.add(rpc);
        } else {
            this.invokeRemotely(null, rpc, sync, usePriorityQueue);
        }
    }

    @Override
    public final void broadcastRpcCommandInFuture(ReplicableCommand rpc, NotifyingNotifiableFuture<Object> l) {
        this.broadcastRpcCommandInFuture(rpc, false, l);
    }

    @Override
    public final void broadcastRpcCommandInFuture(ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> l) {
        this.invokeRemotelyInFuture(null, rpc, usePriorityQueue, l);
    }

    @Override
    public final void invokeRemotely(List<Address> recipients, ReplicableCommand rpc, boolean sync) throws ReplicationException {
        this.invokeRemotely(recipients, rpc, sync, false);
    }

    @Override
    public final void invokeRemotely(List<Address> recipients, ReplicableCommand rpc, boolean sync, boolean usePriorityQueue) throws ReplicationException {
        if (trace) {
            log.trace("Broadcasting call " + rpc + " to recipient list " + recipients);
        }
        if (this.useReplicationQueue(sync)) {
            this.replicationQueue.add(rpc);
        } else {
            if (!(rpc instanceof CacheRpcCommand)) {
                rpc = this.cf.buildSingleRpcCommand(rpc);
            }
            try {
                List<Response> rsps = this.invokeRemotely(recipients, rpc, this.getResponseMode(sync), this.configuration.getSyncReplTimeout(), usePriorityQueue);
                if (trace) {
                    log.trace("responses=" + rsps);
                }
                if (sync) {
                    this.checkResponses(rsps);
                }
            }
            catch (CacheException e) {
                log.error((Object)"Replication exception", e);
                throw e;
            }
            catch (Exception ex) {
                log.error((Object)"Unexpected exception", ex);
                throw new ReplicationException("Unexpected exception while replicating", ex);
            }
        }
    }

    @Override
    public final void invokeRemotelyInFuture(List<Address> recipients, ReplicableCommand rpc, NotifyingNotifiableFuture<Object> l) {
        this.invokeRemotelyInFuture(recipients, rpc, false, l);
    }

    @Override
    public final void invokeRemotelyInFuture(final List<Address> recipients, final ReplicableCommand rpc, final boolean usePriorityQueue, final NotifyingNotifiableFuture<Object> l) {
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() {
                RpcManagerImpl.this.invokeRemotely((List<Address>)recipients, rpc, true, usePriorityQueue);
                l.notifyDone();
                return null;
            }
        };
        l.setNetworkFuture(this.asyncExecutor.submit(c));
    }

    @Override
    public Transport getTransport() {
        return this.t;
    }

    @Override
    public Address getCurrentStateTransferSource() {
        return this.currentStateTransferSource;
    }

    private ResponseMode getResponseMode(boolean sync) {
        return sync ? ResponseMode.SYNCHRONOUS : (this.configuration.isUseAsyncMarshalling() ? ResponseMode.ASYNCHRONOUS : ResponseMode.ASYNCHRONOUS_WITH_SYNC_MARSHALLING);
    }

    private void checkResponses(List rsps) {
        if (rsps != null) {
            for (Object rsp : rsps) {
                if (rsp == null || !(rsp instanceof Throwable)) continue;
                Throwable throwable = (Throwable)rsp;
                if (trace) {
                    log.trace((Object)"Received Throwable from remote cache", throwable);
                }
                throw new ReplicationException(throwable);
            }
        }
    }

    @ManagedOperation
    public void resetStatistics() {
        this.replicationCount.set(0L);
        this.replicationFailures.set(0L);
    }

    @ManagedAttribute(description="number of successful replications")
    public String getReplicationCount() {
        if (!this.isStatisticsEnabled()) {
            return "N/A";
        }
        return String.valueOf(this.replicationCount.get());
    }

    @ManagedAttribute(description="number of failed replications")
    public String getReplicationFailures() {
        if (!this.isStatisticsEnabled()) {
            return "N/A";
        }
        return String.valueOf(this.replicationFailures.get());
    }

    @ManagedAttribute(description="whether or not jmx statistics are enabled")
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @ManagedAttribute
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @ManagedAttribute
    public String getAddress() {
        if (this.t == null || !this.isStatisticsEnabled()) {
            return "N/A";
        }
        Address address = this.t.getAddress();
        return address == null ? "N/A" : address.toString();
    }

    @ManagedAttribute
    public String getMembers() {
        if (this.t == null || !this.isStatisticsEnabled()) {
            return "N/A";
        }
        List<Address> addressList = this.t.getMembers();
        return addressList.toString();
    }

    @ManagedAttribute
    public String getSuccessRatio() {
        if (this.replicationCount.get() == 0L || !this.statisticsEnabled) {
            return "N/A";
        }
        double totalCount = this.replicationCount.get() + this.replicationFailures.get();
        double ration = (double)this.replicationCount.get() / totalCount * 100.0;
        return NumberFormat.getInstance().format(ration) + "%";
    }

    public void setTransport(Transport t) {
        this.t = t;
    }
}

