/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.jboss.Externalizer;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;

public class TransientCacheEntryExternalizer
implements Externalizer {
    private static final long serialVersionUID = -1076893995615398371L;

    public void writeObject(Marshaller output, Object subject) throws IOException {
        TransientCacheEntry ice = (TransientCacheEntry)subject;
        output.writeObject(ice.getKey());
        output.writeObject(ice.getValue());
        UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, ice.getLastUsed());
        output.writeLong(ice.getMaxIdle());
    }

    public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
        Object k = input.readObject();
        Object v = input.readObject();
        long lastUsed = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
        Long maxIdle = input.readLong();
        return InternalEntryFactory.create(k, v, -1L, -1L, lastUsed, maxIdle);
    }
}

