/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss.externalizers;

import java.io.IOException;
import org.infinispan.commands.RemoteCommandFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.marshall.jboss.Externalizer;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;

public class ReplicableCommandExternalizer
implements Externalizer {
    private RemoteCommandFactory cmdFactory;

    public void init(RemoteCommandFactory cmdFactory) {
        this.cmdFactory = cmdFactory;
    }

    public void writeObject(Marshaller output, Object subject) throws IOException {
        ReplicableCommand command = (ReplicableCommand)subject;
        output.writeShort((int)command.getCommandId());
        Object[] args = command.getParameters();
        int numArgs = args == null ? 0 : args.length;
        output.writeByte(numArgs);
        for (int i = 0; i < numArgs; ++i) {
            output.writeObject(args[i]);
        }
    }

    public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
        short methodId = input.readShort();
        int numArgs = input.readByte();
        Object[] args = null;
        if (numArgs > 0) {
            args = new Object[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                args[i] = input.readObject();
            }
        }
        return this.cmdFactory.fromStream((byte)methodId, args);
    }
}

