/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.jboss.Externalizer;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;

public class MortalCacheValueExternalizer
implements Externalizer {
    private static final long serialVersionUID = 7962755251611394481L;

    public void writeObject(Marshaller output, Object subject) throws IOException {
        MortalCacheValue icv = (MortalCacheValue)subject;
        output.writeObject(icv.getValue());
        UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, icv.getCreated());
        output.writeLong(icv.getLifespan());
    }

    public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
        Object v = input.readObject();
        long created = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
        Long lifespan = input.readLong();
        return InternalEntryFactory.createValue(v, created, lifespan, -1L, -1L);
    }
}

