/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jcip.annotations.Immutable;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.jboss.Externalizer;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;

@Immutable
public class MortalCacheEntryExternalizer
implements Externalizer {
    private static final long serialVersionUID = -6500630714670073716L;

    public void writeObject(Marshaller output, Object subject) throws IOException {
        MortalCacheEntry ice = (MortalCacheEntry)subject;
        output.writeObject(ice.getKey());
        output.writeObject(ice.getValue());
        UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, ice.getCreated());
        output.writeLong(ice.getLifespan());
    }

    public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
        Object k = input.readObject();
        Object v = input.readObject();
        long created = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
        Long lifespan = input.readLong();
        return InternalEntryFactory.create(k, v, created, lifespan, -1L, -1L);
    }
}

