/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.infinispan.marshall.jboss.Externalizer;
import org.infinispan.marshall.jboss.MarshallUtil;
import org.infinispan.util.FastCopyHashMap;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.util.IdentityIntMap;

public class MapExternalizer
implements Externalizer {
    private static final int HASHMAP = 0;
    private static final int TREEMAP = 1;
    private static final int FASTCOPYHASHMAP = 2;
    private final IdentityIntMap<Class<?>> numbers = new IdentityIntMap(3);

    public MapExternalizer() {
        this.numbers.put(HashMap.class, 0);
        this.numbers.put(TreeMap.class, 1);
        this.numbers.put(FastCopyHashMap.class, 2);
    }

    public void writeObject(Marshaller output, Object subject) throws IOException {
        int number = this.numbers.get(subject.getClass(), -1);
        output.writeByte(number);
        MarshallUtil.marshallMap((Map)subject, (ObjectOutput)output);
    }

    public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        Map subject = null;
        switch (magicNumber) {
            case 0: {
                subject = new HashMap();
                break;
            }
            case 1: {
                subject = new TreeMap();
                break;
            }
            case 2: {
                subject = new FastCopyHashMap();
            }
        }
        MarshallUtil.unmarshallMap(subject, (ObjectInput)input);
        return subject;
    }
}

