/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.decorators;

import java.io.ObjectInput;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.AbstractDelegatingStore;
import org.infinispan.loaders.decorators.SingletonStoreConfig;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.manager.CacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.Event;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonStore
extends AbstractDelegatingStore {
    private static final Log log = LogFactory.getLog(SingletonStore.class);
    private static final boolean trace = log.isTraceEnabled();
    CacheManager cacheManager;
    Cache cache;
    SingletonStoreConfig config;
    private static final String THREAD_NAME = "SingletonStorePusherThread";
    private final ExecutorService executor;
    Future<?> pushStateFuture;
    private Address localAddress;
    private volatile boolean active;

    public SingletonStore(CacheStore delegate, Cache cache, SingletonStoreConfig config) {
        super(delegate);
        this.cacheManager = cache == null ? null : cache.getCacheManager();
        this.cache = cache;
        this.config = config;
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread(r, SingletonStore.THREAD_NAME);
            }
        });
    }

    @Override
    public void store(InternalCacheEntry ed) throws CacheLoaderException {
        if (this.active) {
            if (trace) {
                log.trace((Object)"Storing key {0}.  Instance: {1}", ed.getKey(), this);
            }
            super.store(ed);
        } else if (trace) {
            log.trace((Object)"Not storing key {0}.  Instance: {1}", ed.getKey(), this);
        }
    }

    @Override
    public void fromStream(ObjectInput inputStream) throws CacheLoaderException {
        if (this.active) {
            super.fromStream(inputStream);
        }
    }

    @Override
    public void clear() throws CacheLoaderException {
        if (this.active) {
            super.clear();
        }
    }

    @Override
    public boolean remove(Object key) throws CacheLoaderException {
        return this.active && super.remove(key);
    }

    @Override
    public void purgeExpired() throws CacheLoaderException {
        if (this.active) {
            super.purgeExpired();
        }
    }

    @Override
    public void commit(GlobalTransaction tx) throws CacheLoaderException {
        if (this.active) {
            super.commit(tx);
        }
    }

    @Override
    public void rollback(GlobalTransaction tx) {
        if (this.active) {
            super.rollback(tx);
        }
    }

    @Override
    public void prepare(List<? extends Modification> list, GlobalTransaction tx, boolean isOnePhase) throws CacheLoaderException {
        if (this.active) {
            super.prepare(list, tx, isOnePhase);
        }
    }

    @Override
    public void start() throws CacheLoaderException {
        this.cacheManager.addListener(new SingletonStoreListener());
        super.start();
    }

    protected Callable<?> createPushStateTask() {
        return new Callable(){

            public Object call() throws Exception {
                boolean debugEnabled = log.isDebugEnabled();
                if (debugEnabled) {
                    log.debug("start pushing in-memory state to cache cacheLoader");
                }
                SingletonStore.this.pushState(SingletonStore.this.cache);
                if (debugEnabled) {
                    log.debug("in-memory state passed to cache cacheLoader successfully");
                }
                return null;
            }
        };
    }

    protected void pushState(Cache cache) throws Exception {
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        Set<Object> keys = dc.keySet();
        for (Object k : keys) {
            InternalCacheEntry entry = dc.get(k);
            if (entry == null) continue;
            this.store(entry);
        }
    }

    protected void awaitForPushToFinish(Future future, long timeout, TimeUnit unit) {
        block7: {
            boolean debugEnabled = log.isDebugEnabled();
            try {
                if (debugEnabled) {
                    log.debug("wait for state push to cache loader to finish");
                }
                future.get(timeout, unit);
            }
            catch (TimeoutException e) {
                if (debugEnabled) {
                    log.debug("timed out waiting for state push to cache loader to finish");
                }
            }
            catch (ExecutionException e) {
                if (debugEnabled) {
                    log.debug("exception reported waiting for state push to cache loader to finish");
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                if (!trace) break block7;
                log.trace("wait for state push to cache loader to finish was interrupted");
            }
        }
    }

    protected void activeStatusChanged(boolean newActiveState) throws PushStateException {
        this.active = newActiveState;
        log.debug((Object)"changed mode {0}", this);
        if (this.active && this.config.isPushStateWhenCoordinator()) {
            this.doPushState();
        }
    }

    private boolean isCoordinator(List<Address> newView, Address currentAddress) {
        if (!currentAddress.equals(this.localAddress)) {
            this.localAddress = currentAddress;
        }
        if (this.localAddress != null) {
            return newView.size() > 0 && this.localAddress.equals(newView.get(0));
        }
        return this.active;
    }

    private void doPushState() throws PushStateException {
        if (this.pushStateFuture == null || this.pushStateFuture.isDone()) {
            Callable<?> task = this.createPushStateTask();
            this.pushStateFuture = this.executor.submit(task);
            try {
                this.waitForTaskToFinish(this.pushStateFuture, this.config.getPushStateTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new PushStateException("unable to complete in memory state push to cache loader", e);
            }
        } else {
            this.awaitForPushToFinish(this.pushStateFuture, this.config.getPushStateTimeout(), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTaskToFinish(Future future, long timeout, TimeUnit unit) throws Exception {
        try {
            future.get(timeout, unit);
        }
        catch (TimeoutException e) {
            throw new Exception("task timed out", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (trace) {
                log.trace("task was interrupted");
            }
        }
        finally {
            future.cancel(true);
        }
    }

    public String toString() {
        return "SingletonStore: localAddress=" + this.localAddress + ", active=" + this.active;
    }

    public static class PushStateException
    extends Exception {
        private static final long serialVersionUID = 5542893943730200886L;

        public PushStateException(String message, Throwable cause) {
            super(message, cause);
        }

        public PushStateException(Throwable cause) {
            super(cause);
        }
    }

    @Listener
    public class SingletonStoreListener {
        @CacheStarted
        public void cacheStarted(Event e) {
            SingletonStore.this.localAddress = SingletonStore.this.cacheManager.getAddress();
            SingletonStore.this.active = SingletonStore.this.cacheManager.isCoordinator();
        }

        @ViewChanged
        public void viewChange(ViewChangedEvent event) {
            boolean tmp = SingletonStore.this.isCoordinator(event.getNewMemberList(), event.getLocalAddress());
            if (SingletonStore.this.active != tmp) {
                try {
                    SingletonStore.this.activeStatusChanged(tmp);
                }
                catch (PushStateException e) {
                    log.error((Object)"exception reported changing cache active status", e);
                }
            }
        }
    }
}

