/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.io.IOException;
import java.io.NotSerializableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.marshall.MarshalledValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshalledValueInterceptor
extends CommandInterceptor {
    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        HashSet<MarshalledValue> marshalledValues = new HashSet<MarshalledValue>();
        Map map = this.wrapMap(command.getMap(), marshalledValues, ctx);
        command.setMap(map);
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.compactAndProcessRetVal(marshalledValues, retVal);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        MarshalledValue key = null;
        MarshalledValue value = null;
        if (!MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            key = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(key);
        }
        if (!MarshalledValue.isTypeExcluded(command.getValue().getClass())) {
            value = this.createMarshalledValue(command.getValue(), ctx);
            command.setValue(value);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        this.compact(key);
        this.compact(value);
        return this.processRetVal(retVal);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        MarshalledValue value = null;
        if (!MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            value = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(value);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        this.compact(value);
        return this.processRetVal(retVal);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        MarshalledValue mv = null;
        if (!MarshalledValue.isTypeExcluded(command.getKey().getClass())) {
            mv = this.createMarshalledValue(command.getKey(), ctx);
            command.setKey(mv);
            this.compact(mv);
        }
        Object retVal = this.invokeNextInterceptor(ctx, command);
        this.compact(mv);
        return this.processRetVal(retVal);
    }

    private Object compactAndProcessRetVal(Set<MarshalledValue> marshalledValues, Object retVal) throws IOException, ClassNotFoundException {
        if (this.trace) {
            this.log.trace("Compacting MarshalledValues created");
        }
        for (MarshalledValue mv : marshalledValues) {
            this.compact(mv);
        }
        return this.processRetVal(retVal);
    }

    private void compact(MarshalledValue mv) {
        if (mv == null) {
            return;
        }
        mv.compact(false, false);
    }

    private Object processRetVal(Object retVal) throws IOException, ClassNotFoundException {
        if (retVal instanceof MarshalledValue) {
            if (this.trace) {
                this.log.trace("Return value is a MarshalledValue.  Unwrapping.");
            }
            retVal = ((MarshalledValue)retVal).get();
        }
        return retVal;
    }

    protected Map wrapMap(Map<Object, Object> m, Set<MarshalledValue> marshalledValues, InvocationContext ctx) throws NotSerializableException {
        if (m == null) {
            if (this.trace) {
                this.log.trace("Map is nul; returning an empty map.");
            }
            return Collections.emptyMap();
        }
        if (this.trace) {
            this.log.trace("Wrapping map contents of argument " + m);
        }
        HashMap<Object, Object> copy = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> me : m.entrySet()) {
            Object newValue;
            Object key = me.getKey();
            Object value = me.getValue();
            Object newKey = key == null || MarshalledValue.isTypeExcluded(key.getClass()) ? key : this.createMarshalledValue(key, ctx);
            Object object = newValue = value == null || MarshalledValue.isTypeExcluded(value.getClass()) ? value : this.createMarshalledValue(value, ctx);
            if (newKey instanceof MarshalledValue) {
                marshalledValues.add((MarshalledValue)newKey);
            }
            if (newValue instanceof MarshalledValue) {
                marshalledValues.add((MarshalledValue)newValue);
            }
            copy.put(newKey, newValue);
        }
        return copy;
    }

    protected MarshalledValue createMarshalledValue(Object toWrap, InvocationContext ctx) throws NotSerializableException {
        return new MarshalledValue(toWrap, ctx.isOriginLocal());
    }
}

