/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.config.ConfigurationException;
import org.infinispan.executors.ExecutorFactory;
import org.infinispan.executors.ScheduledExecutorFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.NamedComponentFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultFactoryFor(classes={ExecutorService.class, Executor.class, ScheduledExecutorService.class})
public class NamedExecutorsFactory
extends NamedComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType, String componentName) {
        try {
            if (componentName.equals("org.infinispan.executors.notification")) {
                return (T)this.buildAndConfigureExecutorService(this.globalConfiguration.getAsyncListenerExecutorFactoryClass(), this.globalConfiguration.getAsyncListenerExecutorProperties());
            }
            if (componentName.equals("org.infinispan.executors.transport")) {
                return (T)this.buildAndConfigureExecutorService(this.globalConfiguration.getAsyncSerializationExecutorFactoryClass(), this.globalConfiguration.getAsyncSerializationExecutorProperties());
            }
            if (componentName.equals("org.infinispan.executors.eviction")) {
                return (T)this.buildAndConfigureScheduledExecutorService(this.globalConfiguration.getEvictionScheduledExecutorFactoryClass(), this.globalConfiguration.getEvictionScheduledExecutorProperties());
            }
            if (componentName.equals("org.infinispan.executors.replicationQueue")) {
                return (T)this.buildAndConfigureScheduledExecutorService(this.globalConfiguration.getReplicationQueueScheduledExecutorFactoryClass(), this.globalConfiguration.getReplicationQueueScheduledExecutorProperties());
            }
            throw new ConfigurationException("Unknown named executor " + componentName);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to instantiate ExecutorFactory for named component " + componentName, e);
        }
    }

    private ExecutorService buildAndConfigureExecutorService(String factoryName, Properties props) throws Exception {
        ExecutorFactory f = (ExecutorFactory)Util.getInstance(factoryName);
        return f.getExecutor(props);
    }

    private ScheduledExecutorService buildAndConfigureScheduledExecutorService(String factoryName, Properties props) throws Exception {
        ScheduledExecutorFactory f = (ScheduledExecutorFactory)Util.getInstance(factoryName);
        return f.getScheduledExecutor(props);
    }
}

