/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.TransientCacheEntry;

public class ImmortalCacheEntry
extends AbstractInternalCacheEntry {
    ImmortalCacheEntry(Object key, Object value) {
        super(key, value);
    }

    public final boolean isExpired() {
        return false;
    }

    public final boolean canExpire() {
        return false;
    }

    public InternalCacheEntry setMaxIdle(long maxIdle) {
        if (maxIdle > -1L) {
            TransientCacheEntry tce = new TransientCacheEntry();
            tce.setMaxIdle(maxIdle);
            tce.key = this.key;
            tce.value = this.value;
            return tce;
        }
        return this;
    }

    public InternalCacheEntry setLifespan(long lifespan) {
        if (lifespan > -1L) {
            MortalCacheEntry mce = new MortalCacheEntry();
            mce.setLifespan(lifespan);
            mce.key = this.key;
            mce.value = this.value;
            return mce;
        }
        return this;
    }

    public final long getCreated() {
        return -1L;
    }

    public final long getLastUsed() {
        return -1L;
    }

    public final long getLifespan() {
        return -1L;
    }

    public final long getMaxIdle() {
        return -1L;
    }

    public final long getExpiryTime() {
        return -1L;
    }

    public final void touch() {
    }

    public InternalCacheValue toInternalCacheValue() {
        return new ImmortalCacheValue(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmortalCacheEntry that = (ImmortalCacheEntry)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

