/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Map;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.notifications.cachelistener.CacheNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutMapCommand
implements WriteCommand {
    public static final byte COMMAND_ID = 9;
    Map<Object, Object> map;
    CacheNotifier notifier;
    long lifespanMillis = -1L;
    long maxIdleTimeMillis = -1L;

    public PutMapCommand() {
    }

    public PutMapCommand(Map map, CacheNotifier notifier, long lifespanMillis, long maxIdleTimeMillis) {
        this.map = map;
        this.notifier = notifier;
        this.lifespanMillis = lifespanMillis;
        this.maxIdleTimeMillis = maxIdleTimeMillis;
    }

    public void init(CacheNotifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPutMapCommand(ctx, this);
    }

    private MVCCEntry lookupMvccEntry(InvocationContext ctx, Object key) {
        return (MVCCEntry)ctx.lookupEntry(key);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        for (Map.Entry<Object, Object> e : this.map.entrySet()) {
            Object key = e.getKey();
            MVCCEntry me = this.lookupMvccEntry(ctx, key);
            this.notifier.notifyCacheEntryModified(key, me.getValue(), true, ctx);
            me.setValue(e.getValue());
            me.setLifespan(this.lifespanMillis);
            me.setMaxIdle(this.maxIdleTimeMillis);
            this.notifier.notifyCacheEntryModified(key, me.getValue(), false, ctx);
        }
        return null;
    }

    public Map<Object, Object> getMap() {
        return this.map;
    }

    public void setMap(Map<Object, Object> map) {
        this.map = map;
    }

    @Override
    public byte getCommandId() {
        return 9;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.map, this.lifespanMillis, this.maxIdleTimeMillis};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        this.map = (Map)parameters[0];
        this.lifespanMillis = (Long)parameters[1];
        this.maxIdleTimeMillis = (Long)parameters[2];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutMapCommand that = (PutMapCommand)o;
        if (this.lifespanMillis != that.lifespanMillis) {
            return false;
        }
        if (this.maxIdleTimeMillis != that.maxIdleTimeMillis) {
            return false;
        }
        return !(this.map != null ? !((Object)this.map).equals(that.map) : that.map != null);
    }

    public int hashCode() {
        int result = this.map != null ? ((Object)this.map).hashCode() : 0;
        result = 31 * result + (int)(this.lifespanMillis ^ this.lifespanMillis >>> 32);
        result = 31 * result + (int)(this.maxIdleTimeMillis ^ this.maxIdleTimeMillis >>> 32);
        return result;
    }

    public String toString() {
        return "PutMapCommand{map=" + this.map + '}';
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    public long getLifespanMillis() {
        return this.lifespanMillis;
    }

    public long getMaxIdleTimeMillis() {
        return this.maxIdleTimeMillis;
    }
}

