/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.atomic.Operation;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AtomicHashMapDelta
implements Delta {
    private static final Log log = LogFactory.getLog(AtomicHashMapDelta.class);
    private static final boolean trace = log.isTraceEnabled();
    private List<Operation> changelog;

    public DeltaAware merge(DeltaAware d) {
        AtomicHashMap other = d != null && d instanceof AtomicHashMap ? (AtomicHashMap)d : new AtomicHashMap();
        for (Operation o : this.changelog) {
            o.replay(other.delegate);
        }
        other.commit();
        return other;
    }

    public void addOperation(Operation o) {
        if (this.changelog == null) {
            this.changelog = new LinkedList<Operation>();
        }
        this.changelog.add(o);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (trace) {
            log.trace("Serializing changelog " + this.changelog);
        }
        out.writeObject(this.changelog);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.changelog = (List)in.readObject();
        if (trace) {
            log.trace("Deserialized changelog " + this.changelog);
        }
    }

    public String toString() {
        return "AtomicHashMapDelta{changelog=" + this.changelog + '}';
    }

    public int getChangeLogSize() {
        return this.changelog == null ? 0 : this.changelog.size();
    }
}

