/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapCache;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.LockControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.NonVolatile;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheManager;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.marshall.Marshaller;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.util.concurrent.FutureListener;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonVolatile
public class CacheDelegate<K, V>
implements AdvancedCache<K, V>,
AtomicMapCache<K, V> {
    protected InvocationContextContainer icc;
    protected CommandsFactory commandsFactory;
    protected InterceptorChain invoker;
    protected Configuration config;
    protected CacheNotifier notifier;
    protected BatchContainer batchContainer;
    protected ComponentRegistry componentRegistry;
    protected TransactionManager transactionManager;
    protected RpcManager rpcManager;
    protected Marshaller marshaller;
    private String name;
    private EvictionManager evictionManager;
    private DataContainer dataContainer;
    private static final Log log = LogFactory.getLog(CacheDelegate.class);
    private CacheManager cacheManager;
    private StateTransferManager stateTransferManager;
    private ResponseGenerator responseGenerator;
    private long defaultLifespan;
    private long defaultMaxIdleTime;

    public CacheDelegate(String name) {
        this.name = name;
    }

    @Inject
    public void injectDependencies(EvictionManager evictionManager, InvocationContextContainer icc, CommandsFactory commandsFactory, InterceptorChain interceptorChain, Configuration configuration, CacheNotifier notifier, ComponentRegistry componentRegistry, TransactionManager transactionManager, BatchContainer batchContainer, RpcManager rpcManager, DataContainer dataContainer, Marshaller marshaller, ResponseGenerator responseGenerator, CacheManager cacheManager, StateTransferManager stateTransferManager) {
        this.commandsFactory = commandsFactory;
        this.invoker = interceptorChain;
        this.config = configuration;
        this.notifier = notifier;
        this.componentRegistry = componentRegistry;
        this.transactionManager = transactionManager;
        this.batchContainer = batchContainer;
        this.rpcManager = rpcManager;
        this.evictionManager = evictionManager;
        this.dataContainer = dataContainer;
        this.marshaller = marshaller;
        this.cacheManager = cacheManager;
        this.responseGenerator = responseGenerator;
        this.stateTransferManager = stateTransferManager;
        this.icc = icc;
    }

    @Override
    public final V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final boolean remove(Object key, Object value) {
        return this.remove(key, value, (Flag[])null);
    }

    @Override
    public final boolean replace(K key, V oldValue, V newValue) {
        return this.replace(key, oldValue, newValue, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final V replace(K key, V value) {
        return this.replace(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final int size() {
        SizeCommand command = this.commandsFactory.buildSizeCommand();
        return (Integer)this.invoker.invoke(this.getInvocationContext(), command);
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.containsKey(key, null);
    }

    @Override
    public final boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Go away");
    }

    @Override
    public final V get(Object key) {
        return this.get(key, null);
    }

    @Override
    public final V put(K key, V value) {
        return this.put(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final V remove(Object key) {
        return this.remove(key, null);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        this.putAll(map, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final void clear() {
        this.clear(null);
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException("TODO implement me");
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException("TODO implement me");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("TODO implement me");
    }

    @Override
    public final void putForExternalRead(K key, V value) {
        this.putForExternalRead(key, value, null);
    }

    @Override
    public final void evict(K key) {
        EvictCommand command = this.commandsFactory.buildEvictCommand(key);
        this.invoker.invoke(this.icc.createNonTxInvocationContext(), command);
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public void addListener(Object listener) {
        this.notifier.addListener(listener);
    }

    @Override
    public void removeListener(Object listener) {
        this.notifier.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        return this.notifier.getListeners();
    }

    private InvocationContext getInvocationContext() {
        return this.icc.createInvocationContext();
    }

    @Override
    public void lock(K key) {
        if (key == null) {
            throw new IllegalArgumentException("Cannot lock null key");
        }
        this.lock((Collection<? extends K>)Collections.singletonList(key));
    }

    @Override
    public void lock(Collection<? extends K> keys) {
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("Cannot lock empty list of keys");
        }
        LockControlCommand command = this.commandsFactory.buildLockControlCommand(keys, false);
        this.invoker.invoke(this.getInvocationContext(), command);
    }

    @Override
    public void start() {
        this.componentRegistry.start();
        this.defaultLifespan = this.config.getExpirationLifespan();
        this.defaultMaxIdleTime = this.config.getExpirationMaxIdle();
    }

    @Override
    public void stop() {
        this.componentRegistry.stop();
    }

    @Override
    public List<CommandInterceptor> getInterceptorChain() {
        return this.invoker.asList();
    }

    @Override
    public void addInterceptor(CommandInterceptor i, int position) {
        this.invoker.addInterceptor(i, position);
    }

    @Override
    public void addInterceptorAfter(CommandInterceptor i, Class<? extends CommandInterceptor> afterInterceptor) {
        this.invoker.addInterceptorAfter(i, afterInterceptor);
    }

    @Override
    public void addInterceptorBefore(CommandInterceptor i, Class<? extends CommandInterceptor> beforeInterceptor) {
        this.invoker.addInterceptorBefore(i, beforeInterceptor);
    }

    @Override
    public void removeInterceptor(int position) {
        this.invoker.removeInterceptor(position);
    }

    @Override
    public void removeInterceptor(Class<? extends CommandInterceptor> interceptorType) {
        this.invoker.removeInterceptor(interceptorType);
    }

    @Override
    public EvictionManager getEvictionManager() {
        return this.evictionManager;
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void putForExternalRead(K key, V value, Flag ... flags) {
        InvocationContext invocationContext = this.getInvocationContext();
        if (flags != null) {
            invocationContext.setFlags(flags);
        }
        Transaction ongoingTransaction = null;
        try {
            if (this.transactionManager != null && (ongoingTransaction = this.transactionManager.getTransaction()) != null) {
                this.transactionManager.suspend();
            }
            this.putIfAbsent(key, value, Flag.FAIL_SILENTLY, Flag.FORCE_ASYNCHRONOUS, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Caught exception while doing putForExternalRead()", e);
            }
        }
        finally {
            try {
                if (ongoingTransaction != null) {
                    this.transactionManager.resume(ongoingTransaction);
                }
            }
            catch (Exception e) {
                log.debug((Object)"Had problems trying to resume a transaction after putForExternalread()", e);
            }
        }
    }

    @Override
    public final V put(K key, V value, Flag ... flags) {
        return this.put(key, value, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS, flags);
    }

    @Override
    public final V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit, Flag ... flags) {
        InvocationContext ctx = this.getInvocationContext();
        if (flags != null) {
            ctx.setFlags(flags);
        }
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, lifespanUnit.toMillis(lifespan), maxIdleTimeUnit.toMillis(maxIdleTime));
        return (V)this.invoker.invoke(ctx, command);
    }

    @Override
    public final V putIfAbsent(K key, V value, Flag ... flags) {
        return this.putIfAbsent(key, value, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS, flags);
    }

    @Override
    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit, Flag ... flags) {
        InvocationContext context = this.getInvocationContext();
        context.setFlags(flags);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, lifespanUnit.toMillis(lifespan), maxIdleTimeUnit.toMillis(maxIdleTime));
        command.setPutIfAbsent(true);
        return (V)this.invoker.invoke(context, command);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map, Flag ... flags) {
        this.putAll(map, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS, flags);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit, Flag ... flags) {
        InvocationContext ctx = this.getInvocationContext();
        if (flags != null) {
            ctx.setFlags(flags);
        }
        PutMapCommand command = this.commandsFactory.buildPutMapCommand(map, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime));
        this.invoker.invoke(ctx, command);
    }

    @Override
    public final V remove(Object key, Flag ... flags) {
        InvocationContext ctx = this.getInvocationContext();
        if (flags != null) {
            ctx.setFlags(flags);
        }
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, null);
        return (V)this.invoker.invoke(ctx, command);
    }

    public final boolean remove(Object key, Object oldValue, Flag ... flags) {
        InvocationContext ctx = this.getInvocationContext();
        if (flags != null) {
            ctx.setFlags(flags);
        }
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, oldValue);
        return (Boolean)this.invoker.invoke(ctx, command);
    }

    @Override
    public final void clear(Flag ... flags) {
        InvocationContext ctx = this.getInvocationContext();
        if (flags != null) {
            ctx.setFlags(flags);
        }
        ClearCommand command = this.commandsFactory.buildClearCommand();
        this.invoker.invoke(ctx, command);
    }

    @Override
    public final V replace(K k, V v, Flag ... flags) {
        return this.replace(k, v, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS, flags);
    }

    @Override
    public final boolean replace(K k, V oV, V nV, Flag ... flags) {
        return this.replace(k, oV, nV, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS, flags);
    }

    @Override
    public final V replace(K k, V v, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit, Flag ... flags) {
        InvocationContext ctx = this.getInvocationContext();
        if (flags != null) {
            ctx.setFlags(flags);
        }
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(k, null, v, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle));
        return (V)this.invoker.invoke(ctx, command);
    }

    @Override
    public final boolean replace(K k, V oV, V nV, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit, Flag ... flags) {
        InvocationContext ctx = this.getInvocationContext();
        if (flags != null) {
            ctx.setFlags(flags);
        }
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(k, oV, nV, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle));
        return (Boolean)this.invoker.invoke(ctx, command);
    }

    @Override
    public final NotifyingFuture<V> putAsync(K key, V value, Flag ... flags) {
        return this.putAsync(key, value, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS, flags);
    }

    @Override
    public final NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit, Flag ... flags) {
        InvocationContext ctx = this.getInvocationContext();
        if (flags != null) {
            ctx.setFlags(flags);
        }
        ctx.setUseFutureReturnType(true);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, lifespanUnit.toMillis(lifespan), maxIdleTimeUnit.toMillis(maxIdleTime));
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<V> putIfAbsentAsync(K key, V value, Flag ... flags) {
        return this.putIfAbsentAsync(key, value, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS, flags);
    }

    @Override
    public final NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit, Flag ... flags) {
        InvocationContext ctx = this.getInvocationContext();
        if (flags != null) {
            ctx.setFlags(flags);
        }
        ctx.setUseFutureReturnType(true);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, lifespanUnit.toMillis(lifespan), maxIdleTimeUnit.toMillis(maxIdleTime));
        command.setPutIfAbsent(true);
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, Flag ... flags) {
        return this.putAllAsync(map, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS, flags);
    }

    @Override
    public final NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit, Flag ... flags) {
        InvocationContext ctx = this.getInvocationContext();
        if (flags != null) {
            ctx.setFlags(flags);
        }
        ctx.setUseFutureReturnType(true);
        PutMapCommand command = this.commandsFactory.buildPutMapCommand(map, TimeUnit.MILLISECONDS.toMillis(TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan)), TimeUnit.MILLISECONDS.toMillis(TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime)));
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<V> removeAsync(Object key, Flag ... flags) {
        InvocationContext ctx = this.getInvocationContext();
        if (flags != null) {
            ctx.setFlags(flags);
        }
        ctx.setUseFutureReturnType(true);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, null);
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<Void> clearAsync(Flag ... flags) {
        InvocationContext ctx = this.getInvocationContext();
        if (flags != null) {
            ctx.setFlags(flags);
        }
        ctx.setUseFutureReturnType(true);
        ClearCommand command = this.commandsFactory.buildClearCommand();
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<V> replaceAsync(K k, V v, Flag ... flags) {
        return this.replaceAsync(k, v, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS, flags);
    }

    @Override
    public final NotifyingFuture<Boolean> replaceAsync(K k, V oV, V nV, Flag ... flags) {
        return this.replaceAsync(k, oV, nV, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS, flags);
    }

    @Override
    public final NotifyingFuture<V> replaceAsync(K k, V v, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit, Flag ... flags) {
        InvocationContext ctx = this.getInvocationContext();
        if (flags != null) {
            ctx.setFlags(flags);
        }
        ctx.setUseFutureReturnType(true);
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(k, null, v, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle));
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<Boolean> replaceAsync(K k, V oV, V nV, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit, Flag ... flags) {
        InvocationContext ctx = this.getInvocationContext();
        if (flags != null) {
            ctx.setFlags(flags);
        }
        ctx.setUseFutureReturnType(true);
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(k, oV, nV, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle));
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final boolean containsKey(Object key, Flag ... flags) {
        GetKeyValueCommand command;
        Object response;
        InvocationContext ctx = this.getInvocationContext();
        if (flags != null) {
            ctx.setFlags(flags);
        }
        return (response = this.invoker.invoke(ctx, command = this.commandsFactory.buildGetKeyValueCommand(key))) != null;
    }

    @Override
    public final V get(Object key, Flag ... flags) {
        InvocationContext ctx = this.getInvocationContext();
        if (flags != null) {
            ctx.setFlags(flags);
        }
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(key);
        return (V)this.invoker.invoke(ctx, command);
    }

    @Override
    public ComponentStatus getStatus() {
        return this.componentRegistry.getStatus();
    }

    @Override
    public boolean startBatch() {
        if (!this.config.isInvocationBatchingEnabled()) {
            throw new ConfigurationException("Invocation batching not enabled in current configuration!  Please use the <invocationBatching /> element.");
        }
        return this.batchContainer.startBatch();
    }

    @Override
    public void endBatch(boolean successful) {
        if (!this.config.isInvocationBatchingEnabled()) {
            throw new ConfigurationException("Invocation batching not enabled in current configuration!  Please use the <invocationBatching /> element.");
        }
        this.batchContainer.endBatch(successful);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return "4.0.0.ALPHA4";
    }

    public String toString() {
        return "Cache '" + this.name + "'@" + (this.config.getCacheMode().isClustered() ? this.getCacheManager().getAddress() : Integer.valueOf(System.identityHashCode(this)));
    }

    @Override
    public <AMK, AMV> AtomicMap<AMK, AMV> getAtomicMap(K key) throws ClassCastException {
        Object value = this.get(key);
        if (value == null) {
            value = AtomicHashMap.newInstance(this, key);
        }
        return ((AtomicHashMap)value).getProxy(this, key, this.batchContainer, this.icc);
    }

    @Override
    public BatchContainer getBatchContainer() {
        return this.batchContainer;
    }

    @Override
    public InvocationContextContainer getInvocationContextContainer() {
        return this.icc;
    }

    @Override
    public DataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public final V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        return this.put(key, value, lifespan, lifespanUnit, maxIdleTime, idleTimeUnit, (Flag[])null);
    }

    @Override
    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        return this.putIfAbsent(key, value, lifespan, lifespanUnit, maxIdleTime, idleTimeUnit, (Flag[])null);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        PutMapCommand command = this.commandsFactory.buildPutMapCommand(map, lifespanUnit.toMillis(lifespan), idleTimeUnit.toMillis(maxIdleTime));
        this.invoker.invoke(this.getInvocationContext(), command);
    }

    @Override
    public final V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        return this.replace(key, value, lifespan, lifespanUnit, maxIdleTime, idleTimeUnit, (Flag[])null);
    }

    @Override
    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        return this.replace(key, oldValue, value, lifespan, lifespanUnit, maxIdleTime, idleTimeUnit, (Flag[])null);
    }

    private <X> NotifyingFuture<X> wrapInFuture(final Object retval) {
        if (retval instanceof NotifyingFuture) {
            return (NotifyingFuture)retval;
        }
        return new NotifyingFuture<X>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public X get() throws InterruptedException, ExecutionException {
                return retval;
            }

            @Override
            public X get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.get();
            }

            @Override
            public NotifyingFuture<X> attachListener(FutureListener<X> futureListener) {
                futureListener.futureDone(this);
                return this;
            }
        };
    }

    @Override
    public final NotifyingFuture<V> putAsync(K key, V value) {
        return this.putAsync(key, value, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.putAsync(key, value, lifespan, unit, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        InvocationContext ctx = this.getInvocationContext();
        ctx.setUseFutureReturnType(true);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle));
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.putAllAsync(data, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        return this.putAllAsync(data, lifespan, unit, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        InvocationContext ctx = this.getInvocationContext();
        ctx.setUseFutureReturnType(true);
        PutMapCommand command = this.commandsFactory.buildPutMapCommand(data, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle));
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<Void> clearAsync() {
        InvocationContext ctx = this.getInvocationContext();
        ctx.setUseFutureReturnType(true);
        ClearCommand command = this.commandsFactory.buildClearCommand();
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<V> putIfAbsentAsync(K key, V value) {
        return this.putIfAbsentAsync(key, value, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.putIfAbsentAsync(key, value, lifespan, unit, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        InvocationContext ctx = this.getInvocationContext();
        ctx.setUseFutureReturnType(true);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle));
        command.setPutIfAbsent(true);
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<V> removeAsync(Object key) {
        InvocationContext ctx = this.getInvocationContext();
        ctx.setUseFutureReturnType(true);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, null);
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<Boolean> removeAsync(Object key, Object value) {
        InvocationContext ctx = this.getInvocationContext();
        ctx.setUseFutureReturnType(true);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, value);
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<V> replaceAsync(K key, V value) {
        return this.replaceAsync(key, value, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, value, lifespan, unit, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.replaceAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit, (Flag[])null);
    }

    @Override
    public final NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsync(key, oldValue, newValue, TimeUnit.MILLISECONDS.toMillis(this.defaultLifespan), TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, oldValue, newValue, lifespan, unit, TimeUnit.MILLISECONDS.toMillis(this.defaultMaxIdleTime), TimeUnit.MILLISECONDS);
    }

    @Override
    public final NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        InvocationContext ctx = this.getInvocationContext();
        ctx.setUseFutureReturnType(true);
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(key, oldValue, newValue, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle));
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final V put(K key, V value, long lifespan, TimeUnit unit) {
        return this.put(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        return this.putIfAbsent(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.putAll(map, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final V replace(K key, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, oldValue, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    @Override
    public void compact() {
        for (InternalCacheEntry e : this.dataContainer) {
            if (e.getKey() instanceof MarshalledValue) {
                ((MarshalledValue)e.getKey()).compact(true, true);
            }
            if (!(e.getValue() instanceof MarshalledValue)) continue;
            ((MarshalledValue)e.getValue()).compact(true, true);
        }
    }

    @Override
    public RpcManager getRpcManager() {
        return this.rpcManager;
    }
}

