/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jcip.annotations.Immutable;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.marshall.jboss.MarshallUtil;
import org.infinispan.transaction.TransactionLog;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.Externalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class TransactionLogExternalizer
implements Externalizer {
    private static final long serialVersionUID = -7341096933735222157L;

    public void writeExternal(Object subject, ObjectOutput output) throws IOException {
        TransactionLog.LogEntry le = (TransactionLog.LogEntry)subject;
        output.writeObject(le.getTransaction());
        WriteCommand[] cmds = le.getModifications();
        MarshallUtil.writeUnsignedInt(output, cmds.length);
        for (WriteCommand c : cmds) {
            output.writeObject(c);
        }
    }

    public Object createExternal(Class<?> subjectType, ObjectInput input, Creator defaultCreator) throws IOException, ClassNotFoundException {
        GlobalTransaction gtx = (GlobalTransaction)input.readObject();
        int numCommands = MarshallUtil.readUnsignedInt(input);
        WriteCommand[] cmds = new WriteCommand[numCommands];
        for (int i = 0; i < numCommands; ++i) {
            cmds[i] = (WriteCommand)input.readObject();
        }
        return new TransactionLog.LogEntry(gtx, cmds);
    }

    public void readExternal(Object subject, ObjectInput input) throws IOException, ClassNotFoundException {
    }
}

