/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.infinispan.commands.RemoteCommandFactory;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.io.ByteBuffer;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.marshall.AbstractMarshaller;
import org.infinispan.marshall.MarshallerImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.util.stream.MarshalledValueInputStream;

public class VersionAwareMarshaller
extends AbstractMarshaller {
    private static final Log log = LogFactory.getLog(VersionAwareMarshaller.class);
    private boolean trace = log.isTraceEnabled();
    private static final int VERSION_400 = 400;
    private static final int CUSTOM_MARSHALLER = 999;
    private MarshallerImpl defaultMarshaller;
    ClassLoader defaultClassLoader;

    @Inject
    public void init(ClassLoader loader, RemoteCommandFactory remoteCommandFactory) {
        this.defaultMarshaller = new MarshallerImpl();
        this.defaultMarshaller.init(loader, remoteCommandFactory);
    }

    protected int getCustomMarshallerVersionInt() {
        return 999;
    }

    public ByteBuffer objectToBuffer(Object obj) throws IOException {
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(128);
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeShort(400);
        log.trace((Object)"Wrote version {0}", 400);
        this.defaultMarshaller.objectToObjectStream(obj, out);
        out.close();
        return new ByteBuffer(baos.getRawBuffer(), 0, baos.size());
    }

    public Object objectFromByteBuffer(byte[] bytes, int offset, int len) throws IOException, ClassNotFoundException {
        MarshalledValueInputStream in = new MarshalledValueInputStream((InputStream)new ByteArrayInputStream(bytes, offset, len));
        try {
            short versionId = in.readShort();
            log.trace((Object)"Read version {0}", versionId);
        }
        catch (Exception e) {
            log.error("Unable to read version id from first two bytes of stream, barfing.");
            throw new IOException("Unable to read version id from first two bytes of stream.");
        }
        return this.defaultMarshaller.objectFromObjectStream((ObjectInput)in);
    }

    public ObjectOutput startObjectOutput(OutputStream os) throws IOException {
        return this.defaultMarshaller.startObjectOutput(os);
    }

    public void finishObjectOutput(ObjectOutput oo) {
        this.defaultMarshaller.finishObjectOutput(oo);
    }

    public void objectToObjectStream(Object obj, ObjectOutput out) throws IOException {
        out.writeShort(400);
        log.trace((Object)"Wrote version {0}", 400);
        this.defaultMarshaller.objectToObjectStream(obj, out);
    }

    public ObjectInput startObjectInput(InputStream is) throws IOException {
        return this.defaultMarshaller.startObjectInput(is);
    }

    public void finishObjectInput(ObjectInput oi) {
        this.defaultMarshaller.finishObjectInput(oi);
    }

    public Object objectFromObjectStream(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            short versionId = in.readShort();
            log.trace((Object)"Read version {0}", versionId);
        }
        catch (Exception e) {
            log.error("Unable to read version id from first two bytes of stream, barfing.");
            throw new IOException("Unable to read version id from first two bytes of stream.");
        }
        return this.defaultMarshaller.objectFromObjectStream(in);
    }

    public byte[] objectToByteBuffer(Object obj) throws IOException {
        return this.defaultMarshaller.objectToByteBuffer(obj);
    }

    public Object objectFromByteBuffer(byte[] buf) throws IOException, ClassNotFoundException {
        return this.defaultMarshaller.objectFromByteBuffer(buf);
    }
}

