/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.decorators.AsyncStore;
import org.infinispan.loaders.decorators.ChainingCacheStore;
import org.infinispan.loaders.decorators.ReadOnlyStore;
import org.infinispan.loaders.decorators.SingletonStore;
import org.infinispan.loaders.decorators.SingletonStoreConfig;
import org.infinispan.marshall.Marshaller;
import org.infinispan.util.ReflectionUtil;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheLoaderManagerImpl
implements CacheLoaderManager {
    Configuration configuration;
    CacheLoaderManagerConfig clmConfig;
    Cache<Object, Object> cache;
    Marshaller m;
    CacheLoader loader;
    private static final Log log = LogFactory.getLog(CacheLoaderManagerImpl.class);

    @Inject
    public void inject(Cache cache, Marshaller marshaller, Configuration configuration) {
        this.cache = cache;
        this.m = marshaller;
        this.configuration = configuration;
    }

    public CacheLoader getCacheLoader() {
        return this.loader;
    }

    public final CacheStore getCacheStore() {
        if (this.loader != null && this.loader instanceof CacheStore) {
            return (CacheStore)this.loader;
        }
        return null;
    }

    public void purge() {
        CacheStore cs = this.getCacheStore();
        if (cs != null) {
            try {
                cs.clear();
            }
            catch (CacheLoaderException e) {
                throw new CacheException("Unable to purge cache store", e);
            }
        }
    }

    private void purgeLoaders(boolean force) throws Exception {
        CacheStore cs = this.getCacheStore();
        if (cs != null) {
            if (cs instanceof ChainingCacheStore && !force) {
                ((ChainingCacheStore)this.loader).purgeIfNecessary();
            } else {
                CacheStoreConfig first = (CacheStoreConfig)this.clmConfig.getFirstCacheLoaderConfig();
                if (force || first != null && first.isPurgeOnStartup()) {
                    cs.clear();
                }
            }
        }
    }

    public boolean isUsingPassivation() {
        return this.isEnabled() ? this.clmConfig.isPassivation() : false;
    }

    public boolean isShared() {
        return this.isEnabled() ? this.clmConfig.isShared() : false;
    }

    public boolean isFetchPersistentState() {
        return this.isEnabled() ? this.clmConfig.isFetchPersistentState() : false;
    }

    @Start(priority=10)
    public void start() {
        this.clmConfig = this.configuration.getCacheLoaderManagerConfig();
        if (this.clmConfig != null) {
            try {
                this.loader = this.createCacheLoader();
                if (this.loader != null) {
                    this.loader.start();
                }
                this.purgeLoaders(false);
            }
            catch (Exception e) {
                throw new CacheException("Unable to start cache loaders", e);
            }
        }
    }

    public boolean isEnabled() {
        return this.clmConfig != null;
    }

    @Start(priority=50)
    public void preload() {
        if (this.loader != null && this.clmConfig.isPreload()) {
            Set<InternalCacheEntry> state;
            log.debug((Object)"Preloading transient state from cache loader {0}", this.loader);
            long start = 0L;
            long stop = 0L;
            long total = 0L;
            if (log.isDebugEnabled()) {
                start = System.currentTimeMillis();
            }
            try {
                state = this.loader.loadAll();
            }
            catch (CacheLoaderException e) {
                throw new CacheException("Unable to preload!", e);
            }
            for (InternalCacheEntry e : state) {
                this.cache.getAdvancedCache().put(e.getKey(), e.getValue(), e.getLifespan(), TimeUnit.MILLISECONDS, e.getMaxIdle(), TimeUnit.MILLISECONDS, Flag.SKIP_CACHE_STATUS_CHECK);
            }
            if (log.isDebugEnabled()) {
                stop = System.currentTimeMillis();
            }
            if (log.isDebugEnabled()) {
                total = stop - start;
            }
            log.debug((Object)"Preloaded {0} keys in {1} milliseconds", state.size(), total);
        }
    }

    @Stop
    public void stop() {
        if (this.loader != null) {
            try {
                this.loader.stop();
            }
            catch (CacheLoaderException e) {
                throw new CacheException(e);
            }
        }
        this.loader = null;
    }

    CacheLoader createCacheLoader() throws Exception {
        CacheLoader tmpLoader;
        if (this.clmConfig.useChainingCacheLoader()) {
            ChainingCacheStore ccl;
            tmpLoader = ccl = new ChainingCacheStore();
            int numLoadersWithFetchPersistentState = 0;
            for (CacheLoaderConfig cfg : this.clmConfig.getCacheLoaderConfigs()) {
                if (cfg instanceof CacheStoreConfig) {
                    if (((CacheStoreConfig)cfg).isFetchPersistentState()) {
                        ++numLoadersWithFetchPersistentState;
                    }
                    if (numLoadersWithFetchPersistentState > 1) {
                        throw new Exception("Invalid cache loader configuration!!  Only ONE cache loader may have fetchPersistentState set to true.  Cache will not start!");
                    }
                    this.assertNotSingletonAndShared((CacheStoreConfig)cfg);
                }
                CacheLoader l = this.createCacheLoader(cfg, this.cache);
                ccl.addCacheLoader(l, cfg);
            }
        } else {
            CacheLoaderConfig cfg = this.clmConfig.getFirstCacheLoaderConfig();
            tmpLoader = this.createCacheLoader(cfg, this.cache);
            if (cfg instanceof CacheStoreConfig) {
                this.assertNotSingletonAndShared((CacheStoreConfig)cfg);
            }
        }
        ReflectionUtil.setValue(this.clmConfig, "accessible", true);
        return tmpLoader;
    }

    CacheLoader createCacheLoader(CacheLoaderConfig cfg, Cache cache) throws Exception {
        CacheLoader tmpLoader = (CacheLoader)Util.getInstance(cfg.getCacheLoaderClassName());
        if (tmpLoader != null) {
            if (cfg instanceof CacheStoreConfig) {
                SingletonStoreConfig ssc;
                CacheStore tmpStore = (CacheStore)tmpLoader;
                CacheStoreConfig cfg2 = (CacheStoreConfig)cfg;
                if (cfg2.getAsyncStoreConfig().isEnabled()) {
                    tmpStore = new AsyncStore(tmpStore, cfg2.getAsyncStoreConfig());
                    tmpLoader = tmpStore;
                }
                if (cfg2.isIgnoreModifications()) {
                    tmpStore = new ReadOnlyStore(tmpStore);
                    tmpLoader = tmpStore;
                }
                if ((ssc = cfg2.getSingletonStoreConfig()) != null && ssc.isSingletonStoreEnabled()) {
                    tmpStore = new SingletonStore(tmpStore, cache, ssc);
                    tmpLoader = tmpStore;
                }
            }
            tmpLoader.init(cfg, cache, this.m);
        }
        return tmpLoader;
    }

    void assertNotSingletonAndShared(CacheStoreConfig cfg) {
        SingletonStoreConfig ssc = cfg.getSingletonStoreConfig();
        if (ssc != null && ssc.isSingletonStoreEnabled() && this.clmConfig.isShared()) {
            throw new ConfigurationException("Invalid cache loader configuration!!  If a cache loader is configured as a singleton, the cache loader cannot be shared in a cluster!");
        }
    }
}

