/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.Set;
import javax.management.MBeanServer;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.NonVolatile;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.jmx.ComponentsJmxRegistration;
import org.infinispan.jmx.JmxDomainConflictException;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@NonVolatile
public class CacheJmxRegistration {
    private static final Log log = LogFactory.getLog(CacheJmxRegistration.class);
    private AdvancedCache cache;

    @Inject
    public void initialize(AdvancedCache cache) {
        this.cache = cache;
    }

    @Start(priority=14)
    public void registerToMBeanServer() {
        if (this.cache == null) {
            throw new IllegalStateException("The cache should had been injected before a call to this method");
        }
        Configuration config = this.cache.getConfiguration();
        if (config.isExposeJmxStatistics()) {
            ComponentsJmxRegistration registrator = this.buildRegistrator();
            registrator.registerMBeans();
            log.info("MBeans were successfully registered to the platform mbean server.");
        }
    }

    @Stop
    public void unregisterMBeans() {
        if (this.cache == null) {
            return;
        }
        Configuration config = this.cache.getConfiguration();
        if (config.isExposeJmxStatistics()) {
            ComponentsJmxRegistration componentsJmxRegistration = this.buildRegistrator();
            componentsJmxRegistration.unregisterMBeans();
            log.trace("MBeans were successfully unregistered from the mbean server.");
        }
        this.cache = null;
    }

    private ComponentsJmxRegistration buildRegistrator() {
        Set<AbstractComponentRegistry.Component> components = this.cache.getComponentRegistry().getRegisteredComponents();
        GlobalConfiguration configuration = this.cache.getConfiguration().getGlobalConfiguration();
        MBeanServer beanServer = CacheJmxRegistration.getMBeanServer(configuration);
        ComponentsJmxRegistration registrator = new ComponentsJmxRegistration(beanServer, components, this.getGroupName());
        CacheJmxRegistration.updateDomain(registrator, this.cache.getAdvancedCache().getComponentRegistry().getGlobalComponentRegistry(), beanServer);
        return registrator;
    }

    static void updateDomain(ComponentsJmxRegistration registrator, GlobalComponentRegistry componentRegistry, MBeanServer mBeanServer) {
        GlobalConfiguration gc = componentRegistry.getComponent(GlobalConfiguration.class);
        String componentName = CacheJmxRegistration.class.getName() + "_jmxDomain";
        String jmxDomain = componentRegistry.getComponent(String.class, componentName);
        if (jmxDomain == null) {
            jmxDomain = CacheJmxRegistration.getJmxDomain(gc.getJmxDomain(), mBeanServer);
            if (!jmxDomain.equals(gc.getJmxDomain()) && !gc.isAllowDuplicateDomains()) {
                String message = "There's already an cache manager instance registered under '" + gc.getJmxDomain() + "' JMX domain. If you want to allow multiple instances configured with same JMX domain enable " + "'allowDuplicateDomains' attribute in 'globalJmxStatistics' config element";
                if (log.isErrorEnabled()) {
                    log.error(message);
                }
                throw new JmxDomainConflictException(message);
            }
            componentRegistry.registerComponent((Object)jmxDomain, componentName);
        }
        registrator.setJmxDomain(jmxDomain);
    }

    private static String getJmxDomain(String jmxDomain, MBeanServer mBeanServer) {
        String[] registeredDomains = mBeanServer.getDomains();
        int index = 2;
        String finalName = jmxDomain;
        boolean done = false;
        block0: while (!done) {
            done = true;
            for (String domain : registeredDomains) {
                if (!domain.equals(finalName)) continue;
                finalName = jmxDomain + index++;
                done = false;
                continue block0;
            }
        }
        return finalName;
    }

    static MBeanServer getMBeanServer(GlobalConfiguration configuration) {
        String serverLookup = configuration.getMBeanServerLookup();
        try {
            MBeanServerLookup lookup = (MBeanServerLookup)Util.getInstance(serverLookup);
            return lookup.getMBeanServer();
        }
        catch (Exception e) {
            log.error((Object)("Could not instantiate MBeanServerLookup('" + serverLookup + "')"), e);
            throw new CacheException(e);
        }
    }

    private String getGroupName() {
        return this.cache.getName() + "(" + this.cache.getConfiguration().getCacheModeString().toLowerCase() + ")";
    }
}

