/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.base;

import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.rpc.RpcManager;

public abstract class BaseRpcInterceptor
extends CommandInterceptor {
    protected RpcManager rpcManager;
    protected boolean defaultSynchronous;

    @Inject
    public void init(RpcManager rpcManager) {
        this.rpcManager = rpcManager;
    }

    @Start
    public void init() {
        this.defaultSynchronous = this.configuration.getCacheMode().isSynchronous();
    }

    protected final boolean isSynchronous(InvocationContext ctx) {
        if (ctx.hasFlag(Flag.FORCE_SYNCHRONOUS)) {
            return true;
        }
        if (ctx.hasFlag(Flag.FORCE_ASYNCHRONOUS)) {
            return false;
        }
        return this.defaultSynchronous;
    }

    protected final boolean isLocalModeForced(InvocationContext ctx) {
        if (ctx.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            if (this.trace) {
                this.log.debug("LOCAL mode forced on invocation.  Suppressing clustered events.");
            }
            return true;
        }
        return false;
    }
}

