/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.EntryFactory;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class CacheLoaderInterceptor
extends JmxStatsCommandInterceptor {
    private final AtomicLong cacheLoads = new AtomicLong(0L);
    private final AtomicLong cacheMisses = new AtomicLong(0L);
    protected CacheLoaderManager clm;
    protected CacheNotifier notifier;
    protected CacheLoader loader;
    private DataContainer dataContainer;
    private EntryFactory entryFactory;

    @Inject
    protected void injectDependencies(CacheLoaderManager clm, DataContainer dataContainer, EntryFactory entryFactory, CacheNotifier notifier) {
        this.clm = clm;
        this.dataContainer = dataContainer;
        this.notifier = notifier;
        this.entryFactory = entryFactory;
    }

    @Start(priority=15)
    protected void startInterceptor() {
        this.loader = this.clm.getCacheLoader();
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object key = command.getKey();
        if (key != null) {
            this.loadIfNeeded(ctx, key);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object key = command.getKey();
        if (key != null) {
            this.loadIfNeededAndUpdateStats(ctx, key);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        Object[] keys = command.getKeys();
        if (keys != null && keys.length > 0) {
            for (Object key : command.getKeys()) {
                this.loadIfNeeded(ctx, key);
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object key = command.getKey();
        if (key != null) {
            this.loadIfNeededAndUpdateStats(ctx, key);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object key = command.getKey();
        if (key != null) {
            this.loadIfNeededAndUpdateStats(ctx, key);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private boolean loadIfNeeded(InvocationContext ctx, Object key) throws Throwable {
        CacheEntry e = this.entryFactory.wrapEntryForReading(ctx, key);
        if (e == null || e.isNull()) {
            if (!this.loader.containsKey(key)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("No need to load.  Key doesn't exist in the loader.");
                }
                return false;
            }
            boolean keyLocked = this.entryFactory.acquireLock(ctx, key);
            if (this.dataContainer.containsKey(key)) {
                if (keyLocked) {
                    this.entryFactory.releaseLock(key);
                }
                this.log.trace("No need to load.  Key exists in the data container.");
                return true;
            }
            MVCCEntry n = this.entryFactory.wrapEntryForWriting(ctx, key, true, false, keyLocked, false);
            n = this.loadEntry(ctx, key, n);
            return true;
        }
        return true;
    }

    private MVCCEntry loadEntry(InvocationContext ctx, Object key, MVCCEntry entry) throws Exception {
        boolean entryExists;
        this.log.trace((Object)"Loading key {0}", key);
        InternalCacheEntry storedEntry = this.loader.load(key);
        boolean bl = entryExists = storedEntry != null;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Entry exists in loader? " + entryExists);
        }
        if (this.getStatisticsEnabled()) {
            if (entryExists) {
                this.cacheLoads.incrementAndGet();
            } else {
                this.cacheMisses.incrementAndGet();
            }
        }
        if (entryExists) {
            this.sendNotification(key, true, ctx);
            entry.setValue(storedEntry.getValue());
            entry.setLifespan(storedEntry.getLifespan());
            entry.setValid(true);
            this.notifier.notifyCacheEntryLoaded(key, false, ctx);
            this.sendNotification(key, false, ctx);
        }
        return entry;
    }

    protected void sendNotification(Object key, boolean pre, InvocationContext ctx) {
        this.notifier.notifyCacheEntryLoaded(key, pre, ctx);
    }

    private void loadIfNeededAndUpdateStats(InvocationContext ctx, Object key) throws Throwable {
        boolean found = this.loadIfNeeded(ctx, key);
        if (!found && this.getStatisticsEnabled()) {
            this.cacheMisses.incrementAndGet();
        }
    }

    @ManagedAttribute(description="number of cache loader loads")
    public long getCacheLoaderLoads() {
        return this.cacheLoads.get();
    }

    @ManagedAttribute(description="number of cache loader misses")
    public long getCacheLoaderMisses() {
        return this.cacheMisses.get();
    }

    @ManagedOperation
    public void resetStatistics() {
        this.cacheLoads.set(0L);
        this.cacheMisses.set(0L);
    }
}

