/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class EvictionManagerImpl
implements EvictionManager {
    private static final Log log = LogFactory.getLog(EvictionManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    ScheduledFuture evictionTask;
    ScheduledExecutorService executor;
    Configuration configuration;
    Cache cache;
    CacheLoaderManager cacheLoaderManager;
    DataContainer dataContainer;
    CacheStore cacheStore;
    boolean enabled;
    int maxEntries;

    @Inject
    public void initialize(@ComponentName(value="org.infinispan.executors.eviction") ScheduledExecutorService executor, Configuration configuration, Cache cache, DataContainer dataContainer, CacheLoaderManager cacheLoaderManager) {
        this.executor = executor;
        this.configuration = configuration;
        this.cache = cache;
        this.dataContainer = dataContainer;
        this.cacheLoaderManager = cacheLoaderManager;
    }

    @Start(priority=55)
    public void start() {
        boolean bl = this.enabled = this.configuration.getEvictionStrategy() != EvictionStrategy.NONE;
        if (this.enabled) {
            this.maxEntries = this.configuration.getEvictionMaxEntries();
            if (this.cacheLoaderManager != null && this.cacheLoaderManager.isEnabled()) {
                this.cacheStore = this.cacheLoaderManager.getCacheStore();
            }
            if (this.configuration.getEvictionWakeUpInterval() <= 0L) {
                log.info("wakeUpInterval is <= 0, not starting eviction thread");
            } else {
                this.evictionTask = this.executor.scheduleWithFixedDelay(new ScheduledTask(), this.configuration.getEvictionWakeUpInterval(), this.configuration.getEvictionWakeUpInterval(), TimeUnit.MILLISECONDS);
            }
        }
    }

    public void processEviction() {
        int dcsz;
        long start = 0L;
        try {
            if (trace) {
                log.trace("Purging data container of expired entries");
                start = System.currentTimeMillis();
            }
            this.dataContainer.purgeExpired();
            if (trace) {
                log.trace((Object)"Purging data container completed in {0}", Util.prettyPrintTime(System.currentTimeMillis() - start));
            }
        }
        catch (Exception e) {
            log.warn((Object)"Caught exception purging data container!", e);
        }
        if (this.cacheStore != null) {
            try {
                if (trace) {
                    log.trace("Purging cache store of expired entries");
                    start = System.currentTimeMillis();
                }
                this.cacheStore.purgeExpired();
                if (trace) {
                    log.trace((Object)"Purging cache store completed in {0}", Util.prettyPrintTime(System.currentTimeMillis() - start));
                }
            }
            catch (Exception e) {
                log.warn((Object)"Caught exception purging cache store!", e);
            }
        }
        if ((dcsz = this.dataContainer.size()) > this.maxEntries) {
            if (trace) {
                log.trace((Object)"Data container is larger than maxEntries, size is {0}.  Evicting...", dcsz);
                start = System.currentTimeMillis();
            }
            for (InternalCacheEntry ice : this.dataContainer) {
                Object k = ice.getKey();
                try {
                    dcsz = this.dataContainer.size();
                    if (dcsz > this.maxEntries) {
                        if (trace) {
                            log.trace((Object)"Attempting to evict key [{0}]", k);
                        }
                        this.cache.evict(k);
                        continue;
                    }
                    if (!trace) break;
                    log.trace("Evicted enough entries");
                    break;
                }
                catch (Exception e) {
                    log.warn((Object)"Caught exception when iterating through data container.  Current entry is under key [{0}]", e, k);
                }
            }
            if (trace) {
                log.trace((Object)"Eviction process completed in {0}", Util.prettyPrintTime(System.currentTimeMillis() - start));
            }
        } else if (trace) {
            log.trace("Data container is smaller than or equal to the maxEntries; not doing anything");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Stop(priority=5)
    public void stop() {
        if (this.evictionTask != null) {
            this.evictionTask.cancel(true);
        }
    }

    class ScheduledTask
    implements Runnable {
        ScheduledTask() {
        }

        public void run() {
            EvictionManagerImpl.this.processEviction();
        }
    }
}

