/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.ConsistentHash;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.responses.ClusteredGetResponseValidityFilter;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionManagerImpl
implements DistributionManager {
    private final Log log = LogFactory.getLog(DistributionManagerImpl.class);
    private final boolean trace = this.log.isTraceEnabled();
    Configuration configuration;
    ConsistentHash consistentHash;
    RpcManager rpcManager;
    CacheManagerNotifier notifier;
    int replCount;
    ViewChangeListener listener;
    CommandsFactory cf;

    @Inject
    public void init(Configuration configuration, RpcManager rpcManager, CacheManagerNotifier notifier, CommandsFactory cf) {
        this.configuration = configuration;
        this.rpcManager = rpcManager;
        this.notifier = notifier;
        this.cf = cf;
    }

    @Start(priority=20)
    public void start() throws Exception {
        this.replCount = this.configuration.getNumOwners();
        this.consistentHash = (ConsistentHash)Util.getInstance(this.configuration.getConsistentHashClass());
        this.consistentHash.setCaches(this.rpcManager.getTransport().getMembers());
        this.listener = new ViewChangeListener();
        this.notifier.addListener(this.listener);
    }

    @Stop(priority=20)
    public void stop() {
        this.notifier.removeListener(this.listener);
    }

    @Override
    public void rehash(Collection<Address> newList) {
        this.consistentHash.setCaches(newList);
    }

    @Override
    public boolean isLocal(Object key) {
        return this.consistentHash.locate(key, this.replCount).contains(this.rpcManager.getTransport().getAddress());
    }

    @Override
    public List<Address> locate(Object key) {
        return this.consistentHash.locate(key, this.replCount);
    }

    @Override
    public Map<Object, List<Address>> locateAll(Collection<Object> keys) {
        return this.consistentHash.locateAll(keys, this.replCount);
    }

    @Override
    public void transformForL1(CacheEntry entry) {
        if (entry.getLifespan() < 0L || entry.getLifespan() > this.configuration.getL1Lifespan()) {
            entry.setLifespan(this.configuration.getL1Lifespan());
        }
    }

    @Override
    public InternalCacheEntry retrieveFromRemoteSource(Object key) throws Exception {
        ClusteredGetCommand get = this.cf.buildClusteredGetCommand(key);
        ClusteredGetResponseValidityFilter filter = new ClusteredGetResponseValidityFilter(this.locate(key));
        List<Response> responses = this.rpcManager.invokeRemotely(this.locate(key), get, ResponseMode.SYNCHRONOUS, this.configuration.getSyncReplTimeout(), false, filter);
        if (!responses.isEmpty()) {
            for (Response r : responses) {
                if (!(r instanceof SuccessfulResponse)) continue;
                return (InternalCacheEntry)((SuccessfulResponse)r).getResponseValue();
            }
        }
        return null;
    }

    @Listener
    public class ViewChangeListener {
        @ViewChanged
        public void handleViewChange(ViewChangedEvent e) {
            DistributionManagerImpl.this.rehash(e.getNewMemberList());
        }
    }
}

