/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.CacheException;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionTable;
import org.infinispan.transaction.xa.TransactionXaAdapter;

public class InvocationContextContainerImpl
implements InvocationContextContainer {
    private TransactionManager tm;
    private TransactionTable transactionTable;
    ThreadLocal<InvocationContext> icTl = new ThreadLocal();
    private Map<GlobalTransaction, RemoteTxInvocationContext> remoteTxMap = new ConcurrentHashMap<GlobalTransaction, RemoteTxInvocationContext>(20);

    @Inject
    public void init(TransactionManager tm, TransactionTable transactionTable) {
        this.tm = tm;
        this.transactionTable = transactionTable;
    }

    public InvocationContext createInvocationContext() {
        NonTxInvocationContext nonTxContext;
        Transaction tx = this.getRunningTx();
        InvocationContext existing = this.icTl.get();
        if (tx != null) {
            LocalTxInvocationContext localContext;
            if (existing == null || !(existing instanceof LocalTxInvocationContext)) {
                localContext = new LocalTxInvocationContext();
                this.icTl.set(localContext);
            } else {
                localContext = (LocalTxInvocationContext)existing;
            }
            TransactionXaAdapter xaAdapter = this.transactionTable.getXaCacheAdapter(tx);
            localContext.setXaCache(xaAdapter);
            return localContext;
        }
        if (existing == null || !(existing instanceof NonTxInvocationContext)) {
            nonTxContext = new NonTxInvocationContext();
            this.icTl.set(nonTxContext);
        } else {
            nonTxContext = (NonTxInvocationContext)existing;
        }
        nonTxContext.setOriginLocal(true);
        return nonTxContext;
    }

    public LocalTxInvocationContext createTxInvocationContext() {
        InvocationContext existing = this.icTl.get();
        if (existing != null && existing instanceof LocalTxInvocationContext) {
            return (LocalTxInvocationContext)existing;
        }
        LocalTxInvocationContext localTxContext = new LocalTxInvocationContext();
        this.icTl.set(localTxContext);
        return localTxContext;
    }

    public RemoteTxInvocationContext createRemoteTxInvocationContext() {
        InvocationContext existing = this.icTl.get();
        if (existing != null && existing instanceof RemoteTxInvocationContext) {
            return (RemoteTxInvocationContext)existing;
        }
        RemoteTxInvocationContext remoteTxContext = new RemoteTxInvocationContext();
        this.icTl.set(remoteTxContext);
        return remoteTxContext;
    }

    public NonTxInvocationContext createRemoteInvocationContext() {
        InvocationContext existing = this.icTl.get();
        if (existing != null && existing instanceof NonTxInvocationContext) {
            NonTxInvocationContext context = (NonTxInvocationContext)existing;
            context.setOriginLocal(false);
            return context;
        }
        NonTxInvocationContext remoteNonTxContext = new NonTxInvocationContext();
        remoteNonTxContext.setOriginLocal(false);
        this.icTl.set(remoteNonTxContext);
        return remoteNonTxContext;
    }

    public InvocationContext getInvocationContext() {
        InvocationContext invocationContext = this.icTl.get();
        if (invocationContext == null) {
            throw new IllegalStateException("This method can only be called after associating the current thread with a context");
        }
        return invocationContext;
    }

    public InvocationContext suspend() {
        InvocationContext invocationContext = this.icTl.get();
        this.icTl.remove();
        return invocationContext;
    }

    public void resume(InvocationContext ctxt) {
        if (ctxt != null) {
            this.icTl.set(ctxt);
        }
    }

    private Transaction getRunningTx() {
        try {
            return this.tm == null ? null : this.tm.getTransaction();
        }
        catch (SystemException e) {
            throw new CacheException(e);
        }
    }
}

