/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ReadCommittedEntry
implements MVCCEntry {
    private static final Log log = LogFactory.getLog(ReadCommittedEntry.class);
    private static final boolean trace = log.isTraceEnabled();
    protected Object key;
    protected Object value;
    protected Object oldValue;
    protected byte flags = 0;
    private long lifespan = -1L;
    private long maxIdle = -1L;

    protected ReadCommittedEntry() {
        this.setValid(true);
    }

    public ReadCommittedEntry(Object key, Object value, long lifespan) {
        this.setValid(true);
        this.key = key;
        this.value = value;
        this.lifespan = lifespan;
    }

    protected final boolean isFlagSet(Flags flag) {
        return (this.flags & flag.mask) != 0;
    }

    protected final void setFlag(Flags flag) {
        this.flags = (byte)(this.flags | flag.mask);
    }

    protected final void unsetFlag(Flags flag) {
        this.flags = (byte)(this.flags & ~flag.mask);
    }

    public final long getLifespan() {
        return this.lifespan;
    }

    public final long getMaxIdle() {
        return this.maxIdle;
    }

    public final MVCCEntry setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
        return this;
    }

    public final MVCCEntry setLifespan(long lifespan) {
        this.lifespan = lifespan;
        return this;
    }

    public final Object getKey() {
        return this.key;
    }

    public final Object getValue() {
        return this.value;
    }

    public final Object setValue(Object value) {
        Object oldValue = this.value;
        this.value = value;
        return oldValue;
    }

    public boolean isNull() {
        return false;
    }

    public void copyForUpdate(DataContainer container, boolean writeSkewCheck) {
        if (this.isChanged()) {
            return;
        }
        this.setChanged();
        if (!this.isCreated()) {
            this.oldValue = this.value;
        }
    }

    public final void commit(DataContainer container) {
        if (this.isChanged()) {
            if (trace) {
                log.trace((Object)"Updating entry (key={0} removed={1} valid={2} changed={3} created={4} value={5}]", this.getKey(), this.isRemoved(), this.isValid(), this.isChanged(), this.isCreated(), this.value);
            }
            if (this.value instanceof AtomicHashMap) {
                ((AtomicHashMap)this.value).commit();
            }
            if (this.isRemoved()) {
                container.remove(this.key);
            } else {
                container.put(this.key, this.value, this.lifespan, this.maxIdle);
            }
            this.reset();
        }
    }

    private void reset() {
        this.oldValue = null;
        this.flags = 0;
        this.setValid(true);
    }

    public final void rollback() {
        if (this.isChanged()) {
            this.value = this.oldValue;
            this.reset();
        }
    }

    public final boolean isChanged() {
        return this.isFlagSet(Flags.CHANGED);
    }

    protected final void setChanged() {
        this.setFlag(Flags.CHANGED);
    }

    public boolean isValid() {
        return this.isFlagSet(Flags.VALID);
    }

    public final void setValid(boolean valid) {
        if (valid) {
            this.setFlag(Flags.VALID);
        } else {
            this.unsetFlag(Flags.VALID);
        }
    }

    public final boolean isCreated() {
        return this.isFlagSet(Flags.CREATED);
    }

    public final void setCreated(boolean created) {
        if (created) {
            this.setFlag(Flags.CREATED);
        } else {
            this.unsetFlag(Flags.CREATED);
        }
    }

    public boolean isRemoved() {
        return this.isFlagSet(Flags.REMOVED);
    }

    public final void setRemoved(boolean removed) {
        if (removed) {
            this.setFlag(Flags.REMOVED);
        } else {
            this.unsetFlag(Flags.REMOVED);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + System.identityHashCode(this) + "){" + "key=" + this.key + ", value=" + this.value + ", oldValue=" + this.oldValue + ", isCreated=" + this.isCreated() + ", isChanged=" + this.isChanged() + ", isRemoved=" + this.isRemoved() + ", isValid=" + this.isValid() + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Flags {
        CHANGED(1),
        CREATED(2),
        REMOVED(4),
        VALID(8);

        final byte mask;

        private Flags(int mask) {
            this.mask = (byte)mask;
        }
    }
}

