/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.config.DuplicateCacheNameException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.parsing.RootElementBuilder;
import org.infinispan.config.parsing.XmlConfigHelper;
import org.infinispan.config.parsing.XmlConfigurationParser;
import org.infinispan.config.parsing.XmlParserBase;
import org.infinispan.config.parsing.element.CustomInterceptorsElementParser;
import org.infinispan.config.parsing.element.LoadersElementParser;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.util.FileLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConfigurationParserImpl
extends XmlParserBase
implements XmlConfigurationParser {
    boolean initialized = false;
    Element rootElement;
    GlobalConfiguration gc;
    Map<String, Configuration> namedCaches;

    public XmlConfigurationParserImpl() {
    }

    public XmlConfigurationParserImpl(String fileName) throws IOException {
        this.initialize(fileName);
    }

    public XmlConfigurationParserImpl(InputStream inputStream) throws IOException {
        this.initialize(inputStream);
    }

    @Override
    public void initialize(String fileName) throws IOException {
        if (fileName == null) {
            throw new NullPointerException("File name cannot be null!");
        }
        FileLookup fileLookup = new FileLookup();
        InputStream is = fileLookup.lookupFile(fileName);
        if (is == null) {
            throw new FileNotFoundException("File " + fileName + " could not be found, either on the classpath or on the file system!");
        }
        this.initialize(is);
    }

    @Override
    public void initialize(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("Input stream cannot be null!");
        }
        this.initialized = true;
        this.rootElement = new RootElementBuilder().readRoot(inputStream);
    }

    @Override
    public Configuration parseDefaultConfiguration() throws ConfigurationException {
        this.assertInitialized();
        if (this.gc == null) {
            Element defaultElement = this.getSingleElementInCoreNS("default", this.rootElement);
            if (defaultElement == null) {
                return new Configuration();
            }
            defaultElement.normalize();
            return this.parseConfiguration(defaultElement);
        }
        return this.gc.getDefaultConfiguration();
    }

    @Override
    public Map<String, Configuration> parseNamedConfigurations() throws ConfigurationException {
        this.assertInitialized();
        if (this.namedCaches == null) {
            Set<Element> elements = this.getAllElementsInCoreNS("namedCache", this.rootElement);
            if (elements.isEmpty()) {
                return Collections.emptyMap();
            }
            this.namedCaches = new HashMap<String, Configuration>(elements.size(), 1.0f);
            for (Element e : elements) {
                String configurationName = this.getAttributeValue(e, "name");
                if (this.namedCaches.containsKey(configurationName)) {
                    this.namedCaches = null;
                    throw new DuplicateCacheNameException("Named cache " + configurationName + " is declared more than once!");
                }
                try {
                    this.namedCaches.put(configurationName, this.parseConfiguration(e));
                }
                catch (ConfigurationException ce) {
                    throw new ConfigurationException("Problems configuring named cache '" + configurationName + "'", ce);
                }
            }
        }
        return this.namedCaches;
    }

    @Override
    public GlobalConfiguration parseGlobalConfiguration() {
        this.assertInitialized();
        if (this.gc == null) {
            Element globalElement = this.getSingleElementInCoreNS("global", this.rootElement);
            Configuration defaultConfig = this.parseDefaultConfiguration();
            this.gc = new GlobalConfiguration();
            this.gc.setDefaultConfiguration(defaultConfig);
            if (globalElement != null) {
                globalElement.normalize();
                this.configureAsyncListenerExecutor(this.getSingleElementInCoreNS("asyncListenerExecutor", globalElement), this.gc);
                this.configureAsyncSerializationExecutor(this.getSingleElementInCoreNS("asyncTransportExecutor", globalElement), this.gc);
                this.configureEvictionScheduledExecutor(this.getSingleElementInCoreNS("evictionScheduledExecutor", globalElement), this.gc);
                this.configureReplicationQueueScheduledExecutor(this.getSingleElementInCoreNS("replicationQueueScheduledExecutor", globalElement), this.gc);
                this.configureTransport(this.getSingleElementInCoreNS("transport", globalElement), this.gc);
                this.configureShutdown(this.getSingleElementInCoreNS("shutdown", globalElement), this.gc);
                this.configureSerialization(this.getSingleElementInCoreNS("serialization", globalElement), this.gc);
                this.configureGlobalJmxStatistics(this.getSingleElementInCoreNS("globalJmxStatistics", globalElement), this.gc);
            }
        }
        return this.gc;
    }

    private Configuration parseConfiguration(Element e) {
        Configuration c = new Configuration();
        this.configureLocking(this.getSingleElementInCoreNS("locking", e), c);
        this.configureTransaction(this.getSingleElementInCoreNS("transaction", e), c);
        this.configureCacheJmxStatistics(this.getSingleElementInCoreNS("jmxStatistics", e), c);
        this.configureLazyDeserialization(this.getSingleElementInCoreNS("lazyDeserialization", e), c);
        this.configureInvocationBatching(this.getSingleElementInCoreNS("invocationBatching", e), c);
        this.configureClustering(this.getSingleElementInCoreNS("clustering", e), c);
        this.configureEviction(this.getSingleElementInCoreNS("eviction", e), c);
        this.configureExpiration(this.getSingleElementInCoreNS("expiration", e), c);
        this.configureCacheLoaders(this.getSingleElementInCoreNS("loaders", e), c);
        this.configureCustomInterceptors(this.getSingleElementInCoreNS("customInterceptors", e), c);
        this.configureUnsafe(this.getSingleElementInCoreNS("unsafe", e), c);
        return c;
    }

    private void assertInitialized() {
        if (!this.initialized) {
            throw new ConfigurationException("Parser not initialized.  Please invoke initialize() first, or use a constructor that initializes the parser.");
        }
    }

    void configureClustering(Element e, Configuration config) {
        boolean sync;
        if (e == null) {
            return;
        }
        String mode = this.getAttributeValue(e, "mode").toUpperCase();
        Configuration.CacheMode cacheMode = mode.startsWith("R") ? Configuration.CacheMode.REPL_SYNC : (mode.startsWith("I") ? Configuration.CacheMode.INVALIDATION_SYNC : Configuration.CacheMode.DIST_SYNC);
        Element asyncEl = this.getSingleElementInCoreNS("async", e);
        Element syncEl = this.getSingleElementInCoreNS("sync", e);
        if (syncEl != null && asyncEl != null) {
            throw new ConfigurationException("Cannot have sync and async elements within the same cluster element!");
        }
        boolean bl = sync = asyncEl == null;
        if (sync) {
            config.setCacheMode(cacheMode);
            this.configureSyncMode(syncEl, config);
        } else {
            cacheMode = cacheMode.toAsync();
            config.setCacheMode(cacheMode);
            this.configureAsyncMode(asyncEl, config);
        }
        if (cacheMode.isDistributed()) {
            Element hash;
            Element l1 = this.getSingleElementInCoreNS("l1", e);
            String tmp = this.getAttributeValue(l1, "enabled");
            if (this.existsAttribute(tmp)) {
                config.setL1CacheEnabled(this.getBoolean(tmp));
            }
            if (this.existsAttribute(tmp = this.getAttributeValue(l1, "lifespan"))) {
                config.setL1Lifespan(this.getLong(tmp));
            }
            if (this.existsAttribute(tmp = this.getAttributeValue(l1, "onRehash"))) {
                config.setL1OnRehash(this.getBoolean(tmp));
            }
            if (this.existsAttribute(tmp = this.getAttributeValue(hash = this.getSingleElementInCoreNS("hash", e), "class"))) {
                config.setConsistentHashClass(tmp);
            }
            if (this.existsAttribute(tmp = this.getAttributeValue(hash, "numOwners"))) {
                config.setNumOwners(this.getInt(tmp));
            }
            if (this.existsAttribute(tmp = this.getAttributeValue(hash, "rehashWait"))) {
                config.setRehashWaitTime(this.getLong(tmp));
            }
        } else if (this.getSingleElementInCoreNS("l1", e) != null || this.getSingleElementInCoreNS("hash", e) != null) {
            throw new ConfigurationException("l1 and hash elements cannot be used with cache modes 'REPLICATION' and 'INVALIDATION'!");
        }
        this.configureStateRetrieval(this.getSingleElementInCoreNS("stateRetrieval", e), config);
    }

    void configureStateRetrieval(Element element, Configuration config) {
        if (element == null) {
            return;
        }
        String fetchInMemoryState = this.getAttributeValue(element, "fetchInMemoryState");
        if (this.existsAttribute(fetchInMemoryState)) {
            config.setFetchInMemoryState(this.getBoolean(fetchInMemoryState));
        } else {
            config.setFetchInMemoryState(true);
        }
        String stateRetrievalTimeout = this.getAttributeValue(element, "timeout");
        if (this.existsAttribute(stateRetrievalTimeout)) {
            config.setStateRetrievalTimeout(this.getLong(stateRetrievalTimeout));
        }
    }

    void configureTransaction(Element element, Configuration config) {
        if (element != null) {
            String syncCommitPhase;
            String tmp = this.getAttributeValue(element, "transactionManagerLookupClass");
            if (this.existsAttribute(tmp)) {
                config.setTransactionManagerLookupClass(tmp);
            } else {
                config.setTransactionManagerLookupClass(GenericTransactionManagerLookup.class.getName());
            }
            String syncRollbackPhase = this.getAttributeValue(element, "syncRollbackPhase");
            if (this.existsAttribute(syncRollbackPhase)) {
                config.setSyncRollbackPhase(this.getBoolean(syncRollbackPhase));
            }
            if (this.existsAttribute(syncCommitPhase = this.getAttributeValue(element, "syncCommitPhase"))) {
                config.setSyncCommitPhase(this.getBoolean(syncCommitPhase));
            }
        }
    }

    void configureCustomInterceptors(Element element, Configuration config) {
        if (element == null) {
            return;
        }
        CustomInterceptorsElementParser parser = new CustomInterceptorsElementParser();
        List<CustomInterceptorConfig> interceptorConfigList = parser.parseCustomInterceptors(element);
        config.setCustomInterceptors(interceptorConfigList);
    }

    void configureInvocationBatching(Element element, Configuration config) {
        if (element != null) {
            String enabled = this.getAttributeValue(element, "enabled");
            if (this.existsAttribute(enabled)) {
                config.setInvocationBatchingEnabled(this.getBoolean(enabled));
            } else {
                config.setInvocationBatchingEnabled(true);
            }
        }
    }

    void configureCacheLoaders(Element element, Configuration config) {
        if (element == null) {
            return;
        }
        LoadersElementParser clElementParser = new LoadersElementParser();
        CacheLoaderManagerConfig cacheLoaderConfig = clElementParser.parseLoadersElement(element);
        config.setCacheLoaderManagerConfig(cacheLoaderConfig);
    }

    void configureExpiration(Element expirationElement, Configuration config) {
        if (expirationElement != null) {
            String tmp = this.getAttributeValue(expirationElement, "lifespan");
            if (this.existsAttribute(tmp)) {
                config.setExpirationLifespan(this.getLong(tmp));
            }
            if (this.existsAttribute(tmp = this.getAttributeValue(expirationElement, "maxIdle"))) {
                config.setExpirationMaxIdle(this.getLong(tmp));
            }
        }
    }

    void configureEviction(Element evictionElement, Configuration config) {
        if (evictionElement != null) {
            String tmp = this.getAttributeValue(evictionElement, "strategy");
            if (this.existsAttribute(tmp)) {
                config.setEvictionStrategy(EvictionStrategy.valueOf(tmp.trim().toUpperCase()));
            }
            if (this.existsAttribute(tmp = this.getAttributeValue(evictionElement, "maxEntries"))) {
                config.setEvictionMaxEntries(this.getInt(tmp));
            }
            if (this.existsAttribute(tmp = this.getAttributeValue(evictionElement, "wakeUpInterval"))) {
                config.setEvictionWakeUpInterval(this.getLong(tmp));
            }
        }
    }

    void configureCacheJmxStatistics(Element element, Configuration config) {
        String enabled;
        if (element != null && this.existsAttribute(enabled = this.getAttributeValue(element, "enabled"))) {
            config.setExposeJmxStatistics(this.getBoolean(enabled));
        }
    }

    void configureLazyDeserialization(Element element, Configuration config) {
        String enabled;
        if (element != null && this.existsAttribute(enabled = this.getAttributeValue(element, "enabled"))) {
            config.setUseLazyDeserialization(this.getBoolean(enabled));
        }
    }

    void configureUnsafe(Element element, Configuration configuration) {
        String tmp;
        if (element != null && this.existsAttribute(tmp = this.getAttributeValue(element, "unreliableReturnValues"))) {
            configuration.setUnsafeUnreliableReturnValues(this.getBoolean(tmp));
        }
    }

    void configureInvalidation(Element element, Configuration config) {
        Element sync;
        if (element == null) {
            return;
        }
        Element async = this.getSingleElement("async");
        if (async != null) {
            config.setCacheMode(Configuration.CacheMode.INVALIDATION_ASYNC);
            this.configureAsyncMode(this.getSingleElementInCoreNS("async", element), config);
        }
        if ((sync = this.getSingleElement("sync")) != null) {
            config.setCacheMode(Configuration.CacheMode.INVALIDATION_SYNC);
            this.configureSyncMode(this.getSingleElementInCoreNS("sync", element), config);
        }
    }

    void configureSyncMode(Element element, Configuration config) {
        String replTimeout = this.getAttributeValue(element, "replTimeout");
        if (this.existsAttribute(replTimeout)) {
            config.setSyncReplTimeout(this.getLong(replTimeout));
        }
    }

    void configureAsyncMode(Element element, Configuration config) {
        String tmp = this.getAttributeValue(element, "useReplQueue");
        if (this.existsAttribute(tmp)) {
            config.setUseReplQueue(this.getBoolean(tmp));
        }
        if (this.existsAttribute(tmp = this.getAttributeValue(element, "replQueueInterval"))) {
            config.setReplQueueInterval(this.getLong(tmp));
        }
        if (this.existsAttribute(tmp = this.getAttributeValue(element, "replQueueMaxElements"))) {
            config.setReplQueueMaxElements(this.getInt(tmp));
        }
        if (this.existsAttribute(tmp = this.getAttributeValue(element, "asyncMarshalling"))) {
            config.setUseAsyncMarshalling(this.getBoolean(tmp));
        }
    }

    void configureLocking(Element element, Configuration config) {
        String concurrencyLevel;
        String useLockStriping;
        String writeSkewCheck;
        String lockAcquisitionTimeout;
        String isolationLevel = this.getAttributeValue(element, "isolationLevel");
        if (this.existsAttribute(isolationLevel)) {
            config.setIsolationLevel(IsolationLevel.valueOf(isolationLevel));
        }
        if (this.existsAttribute(lockAcquisitionTimeout = this.getAttributeValue(element, "lockAcquisitionTimeout"))) {
            config.setLockAcquisitionTimeout(this.getLong(lockAcquisitionTimeout));
        }
        if (this.existsAttribute(writeSkewCheck = this.getAttributeValue(element, "writeSkewCheck"))) {
            config.setWriteSkewCheck(this.getBoolean(writeSkewCheck));
        }
        if (this.existsAttribute(useLockStriping = this.getAttributeValue(element, "useLockStriping"))) {
            config.setUseLockStriping(this.getBoolean(useLockStriping));
        }
        if (this.existsAttribute(concurrencyLevel = this.getAttributeValue(element, "concurrencyLevel"))) {
            config.setConcurrencyLevel(this.getInt(concurrencyLevel));
        }
    }

    void configureShutdown(Element element, GlobalConfiguration config) {
        String hookBehavior;
        if (element != null && this.existsAttribute(hookBehavior = this.getAttributeValue(element, "hookBehavior"))) {
            config.setShutdownHookBehavior(hookBehavior);
        }
    }

    void configureTransport(Element e, GlobalConfiguration gc) {
        if (e != null) {
            Properties p;
            String tmp = this.getAttributeValue(e, "transportClass");
            if (this.existsAttribute(tmp)) {
                gc.setTransportClass(tmp);
            } else {
                gc.setTransportClass(GlobalConfiguration.getClusteredDefault().getTransportClass());
            }
            tmp = this.getAttributeValue(e, "clusterName");
            if (this.existsAttribute(tmp)) {
                gc.setClusterName(tmp);
            }
            if (this.existsAttribute(tmp = this.getAttributeValue(e, "distributedSyncTimeout"))) {
                gc.setDistributedSyncTimeout(this.getLong(tmp));
            }
            if ((p = XmlConfigHelper.extractProperties(e)) != null) {
                gc.setTransportProperties(p);
            }
        }
    }

    void configureSerialization(Element e, GlobalConfiguration configuration) {
        if (e != null) {
            String tmp = this.getAttributeValue(e, "marshallerClass");
            if (this.existsAttribute(tmp)) {
                configuration.setMarshallerClass(tmp);
            }
            if (this.existsAttribute(tmp = this.getAttributeValue(e, "version"))) {
                configuration.setMarshallVersion(tmp);
            }
            if (this.existsAttribute(tmp = this.getAttributeValue(e, "objectInputStreamPoolSize"))) {
                configuration.setObjectInputStreamPoolSize(this.getInt(tmp));
            }
            if (this.existsAttribute(tmp = this.getAttributeValue(e, "objectOutputStreamPoolSize"))) {
                configuration.setObjectOutputStreamPoolSize(this.getInt(tmp));
            }
        }
    }

    void configureAsyncListenerExecutor(Element e, GlobalConfiguration gc) {
        if (e != null) {
            Properties p;
            String tmp = this.getAttributeValue(e, "factory");
            if (this.existsAttribute(tmp)) {
                gc.setAsyncListenerExecutorFactoryClass(tmp);
            }
            if ((p = XmlConfigHelper.extractProperties(e)) != null) {
                gc.setAsyncListenerExecutorProperties(p);
            }
        }
    }

    void configureAsyncSerializationExecutor(Element e, GlobalConfiguration gc) {
        if (e != null) {
            Properties p;
            String tmp = this.getAttributeValue(e, "factory");
            if (this.existsAttribute(tmp)) {
                gc.setAsyncSerializationExecutorFactoryClass(tmp);
            }
            if ((p = XmlConfigHelper.extractProperties(e)) != null) {
                gc.setAsyncSerializationExecutorProperties(p);
            }
        }
    }

    void configureEvictionScheduledExecutor(Element e, GlobalConfiguration gc) {
        if (e != null) {
            Properties p;
            String tmp = this.getAttributeValue(e, "factory");
            if (this.existsAttribute(tmp)) {
                gc.setEvictionScheduledExecutorFactoryClass(tmp);
            }
            if ((p = XmlConfigHelper.extractProperties(e)) != null) {
                gc.setEvictionScheduledExecutorProperties(p);
            }
        }
    }

    void configureReplicationQueueScheduledExecutor(Element e, GlobalConfiguration gc) {
        if (e != null) {
            Properties p;
            String tmp = this.getAttributeValue(e, "factory");
            if (this.existsAttribute(tmp)) {
                gc.setReplicationQueueScheduledExecutorFactoryClass(tmp);
            }
            if ((p = XmlConfigHelper.extractProperties(e)) != null) {
                gc.setReplicationQueueScheduledExecutorProperties(p);
            }
        }
    }

    public void configureGlobalJmxStatistics(Element e, GlobalConfiguration c) {
        if (e != null) {
            String allowDuplicateDomains;
            String mBeanServerLookup;
            String jmxDomain;
            String enabled = this.getAttributeValue(e, "enabled");
            if (this.existsAttribute(enabled)) {
                c.setExposeGlobalJmxStatistics(this.getBoolean(enabled));
            }
            if (this.existsAttribute(jmxDomain = this.getAttributeValue(e, "jmxDomain"))) {
                c.setJmxDomain(jmxDomain);
            }
            if (this.existsAttribute(mBeanServerLookup = this.getAttributeValue(e, "mBeanServerLookup"))) {
                c.setMBeanServerLookup(mBeanServerLookup);
            }
            if (this.existsAttribute(allowDuplicateDomains = this.getAttributeValue(e, "allowDuplicateDomains"))) {
                c.setAllowDuplicateDomains(this.getBoolean(allowDuplicateDomains));
            }
        }
    }

    private Element getSingleElement(String elementName) {
        return this.getSingleElementInCoreNS(elementName, this.rootElement);
    }

    public boolean isValidElementRoot(Element element) {
        NodeList elements = element.getElementsByTagName("infinispan");
        return elements != null && elements.getLength() > 0;
    }
}

