/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class BaseRpcCommand
implements CacheRpcCommand {
    protected InterceptorChain interceptorChain;
    protected InvocationContextContainer icc;
    protected String cacheName;
    private static final Log log = LogFactory.getLog(BaseRpcCommand.class);
    private static final boolean trace = log.isTraceEnabled();

    protected BaseRpcCommand(String cacheName) {
        this.cacheName = cacheName;
    }

    BaseRpcCommand() {
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void init(InterceptorChain interceptorChain, InvocationContextContainer icc) {
        this.interceptorChain = interceptorChain;
        this.icc = icc;
    }

    protected final Object processVisitableCommand(ReplicableCommand cacheCommand) throws Throwable {
        if (cacheCommand instanceof VisitableCommand) {
            InvocationContext ctx = this.icc.createRemoteInvocationContext();
            if (trace) {
                log.trace("Invoking command " + cacheCommand + ", with originLocal flag set to " + ctx.isOriginLocal() + ".");
            }
            return this.interceptorChain.invoke(ctx, (VisitableCommand)cacheCommand);
        }
        throw new RuntimeException("Do we still need to deal with non-visitable commands? (" + cacheCommand.getClass().getName() + ")");
    }
}

