/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import org.infinispan.CacheException;
import org.infinispan.commands.LockControlCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.StateTransferControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.transport.Transport;

@Scope(value=Scopes.GLOBAL)
public class RemoteCommandFactory {
    Transport transport;

    @Inject
    public void inject(Transport transport) {
        this.transport = transport;
    }

    public ReplicableCommand fromStream(byte id, Object[] parameters) {
        ReplicableCommand command;
        switch (id) {
            case 8: {
                command = new PutKeyValueCommand();
                break;
            }
            case 3: {
                command = new LockControlCommand();
                break;
            }
            case 9: {
                command = new PutMapCommand();
                break;
            }
            case 10: {
                command = new RemoveCommand();
                break;
            }
            case 11: {
                command = new ReplaceCommand();
                break;
            }
            case 4: {
                command = new GetKeyValueCommand();
                break;
            }
            case 5: {
                command = new ClearCommand();
                break;
            }
            case 12: {
                command = new PrepareCommand();
                break;
            }
            case 14: {
                command = new CommitCommand();
                break;
            }
            case 13: {
                command = new RollbackCommand();
                break;
            }
            case 2: {
                command = new MultipleRpcCommand();
                break;
            }
            case 1: {
                command = new SingleRpcCommand();
                break;
            }
            case 6: {
                command = new InvalidateCommand();
                break;
            }
            case 7: {
                command = new InvalidateL1Command();
                break;
            }
            case 15: {
                command = new StateTransferControlCommand();
                ((StateTransferControlCommand)command).init(this.transport);
                break;
            }
            case 22: {
                command = new ClusteredGetCommand();
                break;
            }
            default: {
                throw new CacheException("Unknown command id " + id + "!");
            }
        }
        command.setParameters(id, parameters);
        return command;
    }
}

