/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Collection;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.transaction.xa.GlobalTransaction;

public class LockControlCommand
extends AbstractTransactionBoundaryCommand {
    public static final int COMMAND_ID = 3;
    private Collection keys;
    private boolean lock;

    public LockControlCommand() {
    }

    public LockControlCommand(Collection keys, String cacheName, boolean lock) {
        this.cacheName = cacheName;
        this.keys = keys;
        this.lock = lock;
    }

    public void attachGlobalTransaction(GlobalTransaction gtx) {
        this.globalTx = gtx;
    }

    public Collection getKeys() {
        return this.keys;
    }

    public boolean isLock() {
        return this.lock;
    }

    public boolean isUnlock() {
        return !this.isLock();
    }

    public Object perform(InvocationContext ignored) throws Throwable {
        boolean remoteTxinitiated;
        if (ignored != null) {
            throw new IllegalStateException("Expected null context!");
        }
        boolean bl = remoteTxinitiated = this.txTable.getRemoteTransaction(this.globalTx) != null;
        if (!remoteTxinitiated) {
            this.txTable.createRemoteTransaction(this.globalTx, new WriteCommand[0]);
        }
        return super.perform(ignored);
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitLockControlCommand(ctx, this);
    }

    public byte getCommandId() {
        return 3;
    }

    public Object[] getParameters() {
        return new Object[]{this.globalTx, this.cacheName, this.keys, this.lock};
    }

    public void setParameters(int commandId, Object[] args) {
        if (commandId != 3) {
            throw new IllegalStateException("Unusupported command id:" + commandId);
        }
        this.globalTx = (GlobalTransaction)args[0];
        this.cacheName = (String)args[1];
        this.keys = (Collection)args[2];
        this.lock = (Boolean)args[3];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockControlCommand that = (LockControlCommand)o;
        if (!super.equals(that)) {
            return false;
        }
        return ((Object)this.keys).equals(that.getKeys());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.keys != null ? ((Object)this.keys).hashCode() : 0);
        result = 31 * result + (this.lock ? 1 : 0);
        return result;
    }

    public String toString() {
        return "LockControlCommand{gtx=" + this.globalTx + ", cacheName='" + this.cacheName + ", lock=" + this.lock + ", keys=" + this.keys + '}';
    }
}

