/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.containers;

import java.util.Arrays;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.invocation.InvocationContextContainer;
import org.infinispan.util.concurrent.locks.OwnableReentrantLock;
import org.infinispan.util.concurrent.locks.containers.AbstractStripedLockContainer;

@ThreadSafe
public class OwnableReentrantStripedLockContainer
extends AbstractStripedLockContainer {
    OwnableReentrantLock[] sharedLocks;
    InvocationContextContainer icc;

    public OwnableReentrantStripedLockContainer(int concurrencyLevel, InvocationContextContainer icc) {
        this.icc = icc;
        this.initLocks(this.calculateNumberOfSegments(concurrencyLevel));
    }

    protected void initLocks(int numLocks) {
        this.sharedLocks = new OwnableReentrantLock[numLocks];
        for (int i = 0; i < numLocks; ++i) {
            this.sharedLocks[i] = new OwnableReentrantLock(this.icc);
        }
    }

    public final OwnableReentrantLock getLock(Object object) {
        return this.sharedLocks[this.hashToIndex(object)];
    }

    public final boolean ownsLock(Object object, Object owner) {
        OwnableReentrantLock lock = this.getLock(object);
        return owner.equals(lock.getOwner());
    }

    public final boolean isLocked(Object object) {
        OwnableReentrantLock lock = this.getLock(object);
        return lock.isLocked();
    }

    public final int getNumLocksHeld() {
        int i = 0;
        for (OwnableReentrantLock l : this.sharedLocks) {
            if (!l.isLocked()) continue;
            ++i;
        }
        return i;
    }

    public String toString() {
        return "OwnableReentrantStripedLockContainer{sharedLocks=" + (this.sharedLocks == null ? null : Arrays.asList(this.sharedLocks)) + '}';
    }

    public int size() {
        return this.sharedLocks.length;
    }
}

