/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.infinispan.util.AbstractMap;
import org.infinispan.util.BidirectionalMap;
import org.infinispan.util.ReversibleOrderedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfinispanCollections {
    private static final ReversibleOrderedSet EMPTY_ROS = new EmptyReversibleOrderedSet();
    private static final BidirectionalMap EMPTY_BIDI_MAP = new EmptyBidiMap();

    public static final <T> ReversibleOrderedSet<T> emptyReversibleOrderedSet() {
        return EMPTY_ROS;
    }

    public static final <K, V> BidirectionalMap<K, V> emptyBidirectionalMap() {
        return EMPTY_BIDI_MAP;
    }

    private static final class EmptyBidiMap
    extends AbstractMap
    implements BidirectionalMap {
        private EmptyBidiMap() {
        }

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean containsKey(Object key) {
            return false;
        }

        public boolean containsValue(Object value) {
            return false;
        }

        public Object get(Object key) {
            return null;
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public ReversibleOrderedSet keySet() {
            return EMPTY_ROS;
        }

        public Collection values() {
            return Collections.emptySet();
        }

        public ReversibleOrderedSet entrySet() {
            return EMPTY_ROS;
        }
    }

    private static final class EmptyReversibleOrderedSet
    extends AbstractSet
    implements ReversibleOrderedSet {
        Iterator it = new Iterator(){

            public boolean hasNext() {
                return false;
            }

            public Object next() {
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };

        private EmptyReversibleOrderedSet() {
        }

        public Iterator iterator() {
            return this.it;
        }

        public int size() {
            return 0;
        }

        public Iterator reverseIterator() {
            return this.it;
        }
    }
}

