/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jcip.annotations.Immutable;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.marshall.jboss.MarshallUtil;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.Externalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class InternalCachedEntryExternalizer
implements Externalizer {
    private static final long serialVersionUID = -3475239737916428837L;

    public void writeExternal(Object subject, ObjectOutput output) throws IOException {
        InternalCacheEntry ice = (InternalCacheEntry)subject;
        output.writeObject(ice.getKey());
        output.writeObject(ice.getValue());
        if (ice.canExpire()) {
            output.writeBoolean(true);
            MarshallUtil.writeUnsignedLong(output, ice.getCreated());
            output.writeLong(ice.getLifespan());
            MarshallUtil.writeUnsignedLong(output, ice.getLastUsed());
            output.writeLong(ice.getMaxIdle());
        } else {
            output.writeBoolean(false);
        }
    }

    public Object createExternal(Class<?> subjectType, ObjectInput input, Creator defaultCreator) throws IOException, ClassNotFoundException {
        Object k = input.readObject();
        Object v = input.readObject();
        boolean canExpire = input.readBoolean();
        if (canExpire) {
            long created = MarshallUtil.readUnsignedLong(input);
            long lifespan = input.readLong();
            long lastUsed = MarshallUtil.readUnsignedLong(input);
            long maxIdle = input.readLong();
            return InternalEntryFactory.create(k, v, created, lifespan, lastUsed, maxIdle);
        }
        return InternalEntryFactory.create(k, v);
    }

    public void readExternal(Object subject, ObjectInput input) throws IOException, ClassNotFoundException {
    }
}

