/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.infinispan.CacheException;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.io.ByteBuffer;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.jboss.CustomObjectTable;
import org.infinispan.marshall.jboss.ExternalizerClassFactory;
import org.infinispan.marshall.jboss.MagicNumberClassTable;
import org.infinispan.remoting.RpcManager;
import org.infinispan.util.Util;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.ContextClassResolver;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SunReflectiveCreator;

@Scope(value=Scopes.GLOBAL)
public class JBossMarshaller
implements Marshaller {
    private static final Log log = LogFactory.getLog(JBossMarshaller.class);
    private static final String DEFAULT_MARSHALLER_FACTORY = "org.jboss.marshalling.river.RiverMarshallerFactory";
    private ClassLoader defaultClassLoader;
    private MarshallingConfiguration configuration;
    private MarshallerFactory factory;
    private MagicNumberClassTable classTable;
    private CustomObjectTable objectTable;
    private ExternalizerClassFactory externalizerFactoryAndObjectTable;

    @Inject
    public void init(ClassLoader defaultCl, RpcManager rpcManager) {
        log.debug("Using JBoss Marshalling based marshaller.");
        this.defaultClassLoader = defaultCl;
        try {
            this.factory = (MarshallerFactory)Util.getInstance(DEFAULT_MARSHALLER_FACTORY);
        }
        catch (Exception e) {
            throw new CacheException("Unable to load JBoss Marshalling marshaller factory org.jboss.marshalling.river.RiverMarshallerFactory", e);
        }
        this.classTable = this.createMagicNumberClassTable();
        this.objectTable = this.createCustomObjectTable();
        this.externalizerFactoryAndObjectTable = this.createCustomExternalizerFactory(rpcManager, this.objectTable);
        this.configuration = new MarshallingConfiguration();
        this.configuration.setCreator((Creator)new SunReflectiveCreator());
        this.configuration.setClassTable((ClassTable)this.classTable);
        this.configuration.setClassExternalizerFactory((ClassExternalizerFactory)this.externalizerFactoryAndObjectTable);
        this.configuration.setObjectTable((ObjectTable)this.objectTable);
        this.configuration.setClassResolver((ClassResolver)new ContextClassResolver());
    }

    @Stop
    public void stop() {
        this.defaultClassLoader = null;
        this.classTable.stop();
        this.objectTable.stop();
        this.externalizerFactoryAndObjectTable.stop();
    }

    public byte[] objectToByteBuffer(Object obj) throws IOException {
        ByteBuffer b = this.objectToBuffer(obj);
        byte[] bytes = new byte[b.getLength()];
        System.arraycopy(b.getBuf(), b.getOffset(), bytes, 0, b.getLength());
        return bytes;
    }

    public ByteBuffer objectToBuffer(Object o) throws IOException {
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(128);
        ObjectOutput marshaller = this.startObjectOutput(baos);
        this.objectToObjectStream(o, marshaller);
        this.finishObjectOutput(marshaller);
        return new ByteBuffer(baos.getRawBuffer(), 0, baos.size());
    }

    public ObjectOutput startObjectOutput(OutputStream os) throws IOException {
        org.jboss.marshalling.Marshaller marshaller = this.factory.createMarshaller(this.configuration);
        marshaller.start(Marshalling.createByteOutput((OutputStream)os));
        return marshaller;
    }

    public void finishObjectOutput(ObjectOutput oo) {
        try {
            ((org.jboss.marshalling.Marshaller)oo).finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectToObjectStream(Object obj, ObjectOutput out) throws IOException {
        ClassLoader toUse = this.defaultClassLoader;
        Thread current = Thread.currentThread();
        ClassLoader old = current.getContextClassLoader();
        if (old != null) {
            toUse = old;
        }
        try {
            current.setContextClassLoader(toUse);
            out.writeObject(obj);
            Object var7_6 = null;
            current.setContextClassLoader(old);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            current.setContextClassLoader(old);
            throw throwable;
        }
    }

    public Object objectFromByteBuffer(byte[] buf) throws IOException, ClassNotFoundException {
        return this.objectFromByteBuffer(buf, 0, buf.length);
    }

    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        ByteArrayInputStream is = new ByteArrayInputStream(buf, offset, length);
        ObjectInput unmarshaller = this.startObjectInput(is);
        Object o = this.objectFromObjectStream(unmarshaller);
        this.finishObjectInput(unmarshaller);
        return o;
    }

    public ObjectInput startObjectInput(InputStream is) throws IOException {
        Unmarshaller unmarshaller = this.factory.createUnmarshaller(this.configuration);
        unmarshaller.start(Marshalling.createByteInput((InputStream)is));
        return unmarshaller;
    }

    public void finishObjectInput(ObjectInput oi) {
        try {
            ((Unmarshaller)oi).finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object objectFromObjectStream(ObjectInput in) throws IOException, ClassNotFoundException {
        return in.readObject();
    }

    public Object objectFromStream(InputStream is) throws IOException, ClassNotFoundException {
        ObjectInput unmarshaller = this.startObjectInput(is);
        Object o = this.objectFromObjectStream(unmarshaller);
        this.finishObjectInput(unmarshaller);
        return o;
    }

    protected MagicNumberClassTable createMagicNumberClassTable() {
        MagicNumberClassTable classTable = new MagicNumberClassTable();
        classTable.init();
        return classTable;
    }

    protected ExternalizerClassFactory createCustomExternalizerFactory(RpcManager rpcManager, CustomObjectTable objectTable) {
        ExternalizerClassFactory externalizerFactory = new ExternalizerClassFactory(rpcManager, objectTable);
        externalizerFactory.init();
        return externalizerFactory;
    }

    private CustomObjectTable createCustomObjectTable() {
        CustomObjectTable objectTable = new CustomObjectTable();
        objectTable.init();
        return objectTable;
    }
}

