/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.infinispan.remoting.responses.RequestIgnoredResponse;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;

public class CustomObjectTable
implements ObjectTable {
    private final List<Object> objects = new ArrayList<Object>();
    private final Map<Object, ObjectTable.Writer> writers = new IdentityHashMap<Object, ObjectTable.Writer>();
    private byte index;

    public void init() {
        this.objects.add(RequestIgnoredResponse.INSTANCE);
        byte by = this.index;
        this.index = (byte)(by + 1);
        this.writers.put(RequestIgnoredResponse.INSTANCE, new CustomObjectWriter(by));
    }

    public void stop() {
        this.writers.clear();
        this.objects.clear();
    }

    public void add(Object o) {
        this.objects.add(o);
        byte by = this.index;
        this.index = (byte)(by + 1);
        this.writers.put(o, new CustomObjectWriter(by));
    }

    public ObjectTable.Writer getObjectWriter(Object o) throws IOException {
        return this.writers.get(o);
    }

    public Object readObject(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        return this.objects.get(unmarshaller.readUnsignedByte());
    }

    @Immutable
    static class CustomObjectWriter
    implements ObjectTable.Writer {
        private final byte id;

        CustomObjectWriter(byte objectId) {
            this.id = objectId;
        }

        public void writeObject(Marshaller marshaller, Object object) throws IOException {
            marshaller.write((int)this.id);
        }
    }
}

