/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.DuplicateCacheNameException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.parsing.XmlConfigurationParser;
import org.infinispan.config.parsing.XmlConfigurationParserImpl;
import org.infinispan.factories.DefaultCacheFactory;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.NonVolatile;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.Lifecycle;
import org.infinispan.manager.CacheManager;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.RpcManager;
import org.infinispan.remoting.transport.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=Scopes.GLOBAL)
@NonVolatile
@MBean(objectName="CacheManager")
public class DefaultCacheManager
implements CacheManager {
    public static final String DEFAULT_CACHE_NAME = "org.infinispan.manager.DefaultCacheManager.DEFAULT_CACHE_NAME";
    protected GlobalConfiguration globalConfiguration;
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private final ConcurrentMap<String, Configuration> configurationOverrides = new ConcurrentHashMap<String, Configuration>();
    private GlobalComponentRegistry globalComponentRegistry;

    public DefaultCacheManager() {
        this(null, null, true);
    }

    public DefaultCacheManager(boolean start) {
        this(null, null, start);
    }

    public DefaultCacheManager(Configuration defaultConfiguration) {
        this(null, defaultConfiguration, true);
    }

    public DefaultCacheManager(Configuration defaultConfiguration, boolean start) {
        this(null, defaultConfiguration, start);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration) {
        this(globalConfiguration, null, true);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, boolean start) {
        this(globalConfiguration, null, start);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, Configuration defaultConfiguration) {
        this(globalConfiguration, defaultConfiguration, true);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, Configuration defaultConfiguration, boolean start) {
        this.globalConfiguration = globalConfiguration == null ? new GlobalConfiguration() : globalConfiguration.clone();
        this.globalConfiguration.setDefaultConfiguration(defaultConfiguration == null ? new Configuration() : defaultConfiguration.clone());
        this.globalComponentRegistry = new GlobalComponentRegistry(this.globalConfiguration, this);
        if (start) {
            this.start();
        }
    }

    public DefaultCacheManager(String configurationFile) throws IOException {
        this(configurationFile, true);
    }

    public DefaultCacheManager(String configurationFile, boolean start) throws IOException {
        try {
            this.initialize(new XmlConfigurationParserImpl(configurationFile));
        }
        catch (RuntimeException re) {
            throw new ConfigurationException(re);
        }
        if (start) {
            this.start();
        }
    }

    public DefaultCacheManager(InputStream configurationStream) throws IOException {
        this(configurationStream, true);
    }

    public DefaultCacheManager(InputStream configurationStream, boolean start) throws IOException {
        try {
            this.initialize(new XmlConfigurationParserImpl(configurationStream));
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (RuntimeException re) {
            throw new ConfigurationException(re);
        }
        if (start) {
            this.start();
        }
    }

    private void initialize(XmlConfigurationParser initializedParser) {
        this.globalConfiguration = initializedParser.parseGlobalConfiguration();
        this.configurationOverrides.putAll(initializedParser.parseNamedConfigurations());
        this.globalComponentRegistry = new GlobalComponentRegistry(this.globalConfiguration, this);
    }

    @Override
    public void defineCache(String cacheName, Configuration configurationOverride) throws DuplicateCacheNameException {
        if (cacheName == null || this.configurationOverrides == null) {
            throw new NullPointerException("Null arguments not allowed");
        }
        if (cacheName.equals(DEFAULT_CACHE_NAME)) {
            throw new IllegalArgumentException("Cache name cannot be used as it is a reserved, internal name");
        }
        if (this.configurationOverrides.putIfAbsent(cacheName, configurationOverride.clone()) != null) {
            throw new DuplicateCacheNameException("Cache name [" + cacheName + "] already in use!");
        }
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        return this.getCache(DEFAULT_CACHE_NAME);
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName) {
        if (cacheName == null) {
            throw new NullPointerException("Null arguments not allowed");
        }
        if (this.caches.containsKey(cacheName)) {
            return (Cache)this.caches.get(cacheName);
        }
        return this.createCache(cacheName);
    }

    @Override
    public String getClusterName() {
        return this.globalConfiguration.getClusterName();
    }

    @Override
    public List<Address> getMembers() {
        if (this.globalComponentRegistry == null) {
            return null;
        }
        RpcManager rpcManager = this.globalComponentRegistry.getComponent(RpcManager.class);
        return rpcManager == null ? null : rpcManager.getTransport().getMembers();
    }

    @Override
    public Address getAddress() {
        if (this.globalComponentRegistry == null) {
            return null;
        }
        RpcManager rpcManager = this.globalComponentRegistry.getComponent(RpcManager.class);
        return rpcManager == null ? null : rpcManager.getLocalAddress();
    }

    @Override
    public boolean isCoordinator() {
        if (this.globalComponentRegistry == null) {
            return false;
        }
        RpcManager rpcManager = this.globalComponentRegistry.getComponent(RpcManager.class);
        return rpcManager != null && rpcManager.getTransport().isCoordinator();
    }

    private Cache createCache(String cacheName) {
        Configuration overrides;
        Configuration c = this.globalConfiguration.getDefaultConfiguration().clone();
        if (!cacheName.equals(DEFAULT_CACHE_NAME) && (overrides = (Configuration)this.configurationOverrides.get(cacheName)) != null) {
            c.applyOverrides(overrides);
        }
        c.assertValid();
        Cache cache = new DefaultCacheFactory().createCache(c, this.globalComponentRegistry, cacheName);
        Cache other = this.caches.putIfAbsent(cacheName, cache);
        if (other == null) {
            cache.start();
            return cache;
        }
        return other;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        Lifecycle defaultCache = null;
        for (Map.Entry entry : this.caches.entrySet()) {
            if (((String)entry.getKey()).equals(DEFAULT_CACHE_NAME)) {
                defaultCache = (Cache)entry.getValue();
                continue;
            }
            ((Cache)entry.getValue()).stop();
        }
        if (defaultCache != null) {
            defaultCache.stop();
        }
        this.globalComponentRegistry.stop();
    }

    @Override
    public void addListener(Object listener) {
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        notifier.addListener(listener);
    }

    @Override
    public void removeListener(Object listener) {
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        notifier.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        return notifier.getListeners();
    }

    @Override
    public ComponentStatus getStatus() {
        return this.globalComponentRegistry.getStatus();
    }

    @ManagedAttribute(description="the defined cache names and their status")
    public String getDefinedCacheNames() {
        StringBuilder result = new StringBuilder("[");
        for (String cacheName : this.configurationOverrides.keySet()) {
            boolean started = this.caches.containsKey(cacheName);
            result.append(cacheName).append(started ? "(created)" : "(not created)");
        }
        result.append("]");
        return result.toString();
    }

    @ManagedAttribute(description="the total number of defined caches")
    public String getDefinedCacheCount() {
        return String.valueOf(this.configurationOverrides.keySet().size());
    }

    @ManagedAttribute(description="number of running caches")
    public String getCreatedCacheCount() {
        return String.valueOf(this.caches.keySet().size());
    }

    public String toString() {
        return super.toString() + "@Address:" + this.getAddress();
    }
}

