/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.logging;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.infinispan.logging.AbstractLogImpl;

public class Log4JLogImpl
extends AbstractLogImpl {
    private final Logger logger;
    private static final Level TRACE;

    public Log4JLogImpl(String category) {
        this.logger = Logger.getLogger((String)category);
    }

    public void trace(Object message) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)TRACE, message, null);
    }

    public void debug(Object message) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.DEBUG, message, null);
    }

    public void info(Object message) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.INFO, message, null);
    }

    public void warn(Object message) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.WARN, message, null);
    }

    public void error(Object message) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.ERROR, message, null);
    }

    public void fatal(Object message) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.FATAL, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)TRACE, message, t);
    }

    public void debug(Object message, Throwable t) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.DEBUG, message, t);
    }

    public void info(Object message, Throwable t) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.INFO, message, t);
    }

    public void warn(Object message, Throwable t) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.WARN, message, t);
    }

    public void error(Object message, Throwable t) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.ERROR, message, t);
    }

    public void fatal(Object message, Throwable t) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.FATAL, message, t);
    }

    public boolean isTraceEnabled() {
        return this.logger.isEnabledFor((Priority)TRACE);
    }

    public boolean isDebugEnabled() {
        return this.logger.isEnabledFor((Priority)Level.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.logger.isEnabledFor((Priority)Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.logger.isEnabledFor((Priority)Level.FATAL);
    }

    static {
        Object trace;
        try {
            trace = Level.class.getDeclaredField("TRACE").get(null);
        }
        catch (Exception e) {
            trace = Level.DEBUG;
        }
        TRACE = trace;
    }
}

