/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.logging;

import org.infinispan.logging.Log;

public abstract class AbstractLogImpl
implements Log {
    public void trace(Object message, Object ... params) {
        if (this.isTraceEnabled()) {
            this.trace(this.substitute(message, params));
        }
    }

    public void debug(Object message, Object ... params) {
        if (this.isDebugEnabled()) {
            this.debug(this.substitute(message, params));
        }
    }

    public void info(Object message, Object ... params) {
        if (this.isInfoEnabled()) {
            this.info(this.substitute(message, params));
        }
    }

    public void warn(Object message, Object ... params) {
        if (this.isWarnEnabled()) {
            this.warn(this.substitute(message, params));
        }
    }

    public void error(Object message, Object ... params) {
        if (this.isErrorEnabled()) {
            this.error(this.substitute(message, params));
        }
    }

    public void fatal(Object message, Object ... params) {
        if (this.isFatalEnabled()) {
            this.fatal(this.substitute(message, params));
        }
    }

    public void trace(Object message, Throwable t, Object ... params) {
        if (this.isTraceEnabled()) {
            this.trace(this.substitute(message, params), t);
        }
    }

    public void debug(Object message, Throwable t, Object ... params) {
        if (this.isDebugEnabled()) {
            this.debug(this.substitute(message, params), t);
        }
    }

    public void info(Object message, Throwable t, Object ... params) {
        if (this.isInfoEnabled()) {
            this.info(this.substitute(message, params), t);
        }
    }

    public void warn(Object message, Throwable t, Object ... params) {
        if (this.isWarnEnabled()) {
            this.warn(this.substitute(message, params), t);
        }
    }

    public void error(Object message, Throwable t, Object ... params) {
        if (this.isErrorEnabled()) {
            this.error(this.substitute(message, params), t);
        }
    }

    public void fatal(Object message, Throwable t, Object ... params) {
        if (this.isFatalEnabled()) {
            this.fatal(this.substitute(message, params), t);
        }
    }

    private Object substitute(Object message, Object ... params) {
        if (params.length == 0) {
            return message;
        }
        StringBuilder value = new StringBuilder(String.valueOf(message));
        for (int i = 0; i < params.length; ++i) {
            String placeholder = "{" + i + "}";
            int phIndex = value.indexOf(placeholder);
            if (phIndex <= -1) continue;
            value = value.replace(phIndex, phIndex + placeholder.length(), String.valueOf(params[i]));
        }
        return value.toString();
    }
}

