/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class StripedLock {
    private static Log log = LogFactory.getLog(StripedLock.class);
    private static final int DEFAULT_CONCURRENCY = 20;
    private final int lockSegmentMask;
    private final int lockSegmentShift;
    final ReentrantReadWriteLock[] sharedLocks;

    public StripedLock() {
        this(20);
    }

    public StripedLock(int concurrency) {
        int numLocks;
        int tempLockSegShift = 0;
        for (numLocks = 1; numLocks < concurrency; numLocks <<= 1) {
            ++tempLockSegShift;
        }
        this.lockSegmentShift = 32 - tempLockSegShift;
        this.lockSegmentMask = numLocks - 1;
        this.sharedLocks = new ReentrantReadWriteLock[numLocks];
        for (int i = 0; i < numLocks; ++i) {
            this.sharedLocks[i] = new ReentrantReadWriteLock();
        }
    }

    public void acquireLock(Object key, boolean exclusive) {
        ReentrantReadWriteLock lock = this.getLock(key);
        if (exclusive) {
            lock.writeLock().lock();
            if (log.isTraceEnabled()) {
                log.trace("WL acquired for '" + key + "'");
            }
        } else {
            lock.readLock().lock();
            if (log.isTraceEnabled()) {
                log.trace("RL acquired for '" + key + "'");
            }
        }
    }

    public boolean acquireLock(String key, boolean exclusive, long millis) {
        ReentrantReadWriteLock lock = this.getLock(key);
        try {
            if (exclusive) {
                return lock.writeLock().tryLock(millis, TimeUnit.MILLISECONDS);
            }
            return lock.readLock().tryLock(millis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.warn((Object)"Thread insterrupted while trying to acquire lock", e);
            return false;
        }
    }

    public void releaseLock(Object key) {
        ReentrantReadWriteLock lock = this.getLock(key);
        if (lock.isWriteLockedByCurrentThread()) {
            lock.writeLock().unlock();
            if (log.isTraceEnabled()) {
                log.trace("WL released for '" + key + "'");
            }
        } else {
            lock.readLock().unlock();
            if (log.isTraceEnabled()) {
                log.trace("RL released for '" + key + "'");
            }
        }
    }

    final ReentrantReadWriteLock getLock(Object o) {
        return this.sharedLocks[this.hashToIndex(o)];
    }

    final int hashToIndex(Object o) {
        return this.hash(o) >>> this.lockSegmentShift & this.lockSegmentMask;
    }

    final int hash(Object x) {
        int h = x.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    public void releaseAllLocks(List<Object> keys) {
        for (Object k : keys) {
            this.releaseLock(k);
        }
    }

    public void acquireAllLocks(List<Object> keys, boolean exclusive) {
        for (Object k : keys) {
            this.acquireLock(k, exclusive);
        }
    }

    public int getTotalLockCount() {
        int count = 0;
        for (ReentrantReadWriteLock lock : this.sharedLocks) {
            count += lock.getReadLockCount();
            count += lock.isWriteLocked() ? 1 : 0;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean aquireGlobalLock(boolean exclusive, long timeout) {
        boolean success = true;
        for (int i = 0; i < this.sharedLocks.length; ++i) {
            Lock toRelease;
            int j;
            Object var9_7;
            block12: {
                Lock toAcquire = exclusive ? this.sharedLocks[i].writeLock() : this.sharedLocks[i].readLock();
                try {
                    success = toAcquire.tryLock(timeout, TimeUnit.MILLISECONDS);
                    if (success) break block12;
                    if (log.isTraceEnabled()) {
                        log.trace("Could not aquire lock on " + toAcquire + ". Exclusive?" + exclusive);
                    }
                    var9_7 = null;
                    if (success) break;
                }
                catch (Throwable throwable) {
                    var9_7 = null;
                    if (!success) {
                        for (j = 0; j < i; ++j) {
                            toRelease = exclusive ? this.sharedLocks[j].writeLock() : this.sharedLocks[j].readLock();
                            toRelease.unlock();
                        }
                    }
                    throw throwable;
                }
                for (j = 0; j < i; ++j) {
                    toRelease = exclusive ? this.sharedLocks[j].writeLock() : this.sharedLocks[j].readLock();
                    toRelease.unlock();
                }
                break;
            }
            var9_7 = null;
            if (success) continue;
            for (j = 0; j < i; ++j) {
                toRelease = exclusive ? this.sharedLocks[j].writeLock() : this.sharedLocks[j].readLock();
                toRelease.unlock();
            }
            {
                continue;
                catch (InterruptedException e) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Cought InterruptedException while trying to aquire global lock", e);
                    }
                    success = false;
                    var9_7 = null;
                    if (success) continue;
                    for (j = 0; j < i; ++j) {
                        toRelease = exclusive ? this.sharedLocks[j].writeLock() : this.sharedLocks[j].readLock();
                        toRelease.unlock();
                    }
                    continue;
                }
            }
        }
        return success;
    }

    public void releaseGlobalLock(boolean exclusive) {
        for (ReentrantReadWriteLock lock : this.sharedLocks) {
            Lock toRelease = exclusive ? lock.writeLock() : lock.readLock();
            toRelease.unlock();
        }
    }

    public int getTotalReadLockCount() {
        int count = 0;
        for (ReentrantReadWriteLock lock : this.sharedLocks) {
            count += lock.getReadLockCount();
        }
        return count;
    }

    public int getSharedLockCount() {
        return this.sharedLocks.length;
    }

    public int getTotalWriteLockCount() {
        int count = 0;
        for (ReentrantReadWriteLock lock : this.sharedLocks) {
            count += lock.isWriteLocked() ? 1 : 0;
        }
        return count;
    }
}

