/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loader.cluster;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.loader.AbstractCacheLoader;
import org.infinispan.loader.CacheLoaderConfig;
import org.infinispan.loader.CacheLoaderException;
import org.infinispan.loader.cluster.ClusterCacheLoaderConfig;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;
import org.infinispan.marshall.Marshaller;
import org.infinispan.remoting.ResponseMode;
import org.infinispan.remoting.RpcManager;
import org.infinispan.remoting.responses.ClusteredGetResponseValidityFilter;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterCacheLoader
extends AbstractCacheLoader {
    private static Log log = LogFactory.getLog(ClusterCacheLoader.class);
    private ClusterCacheLoaderConfig config;
    private RpcManager rpcManager;
    private AdvancedCache cache;

    @Override
    public void init(CacheLoaderConfig config, Cache cache, Marshaller m) {
        this.config = (ClusterCacheLoaderConfig)config;
        this.cache = cache.getAdvancedCache();
        this.rpcManager = this.cache.getRpcManager();
    }

    @Override
    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        if (!this.isCacheReady() || !this.isLocalCall()) {
            return null;
        }
        ClusteredGetCommand clusteredGetCommand = new ClusteredGetCommand(key, this.cache.getName());
        List<Response> response = this.doRemoteCall(clusteredGetCommand);
        if (response.isEmpty()) {
            return null;
        }
        if (response.size() > 1) {
            throw new CacheLoaderException("Response length is always 0 or 1, received: " + response);
        }
        Response firstResponse = response.get(0);
        if (firstResponse.isSuccessful() && firstResponse instanceof SuccessfulResponse) {
            return (InternalCacheEntry)((SuccessfulResponse)firstResponse).getResponseValue();
        }
        String message = "Unknown response from remote cache: " + response;
        log.error(message);
        throw new CacheLoaderException(message);
    }

    @Override
    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        return Collections.EMPTY_SET;
    }

    @Override
    public void start() throws CacheLoaderException {
    }

    @Override
    public void stop() throws CacheLoaderException {
    }

    @Override
    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        throw new IllegalStateException("TODO - please implement me!!!");
    }

    private List<Response> doRemoteCall(ClusteredGetCommand clusteredGetCommand) throws CacheLoaderException {
        HashSet<Address> validMembers = new HashSet<Address>(this.rpcManager.getTransport().getMembers());
        validMembers.remove(this.rpcManager.getLocalAddress());
        ClusteredGetResponseValidityFilter filter = new ClusteredGetResponseValidityFilter(validMembers);
        try {
            return this.rpcManager.invokeRemotely(null, clusteredGetCommand, ResponseMode.WAIT_FOR_VALID_RESPONSE, this.config.getRemoteCallTimeout(), false, filter, false);
        }
        catch (Exception e) {
            log.error((Object)"error while doing remote call", e);
            throw new CacheLoaderException(e);
        }
    }

    private boolean isLocalCall() {
        InvocationContext invocationContext = (InvocationContext)this.cache.getInvocationContextContainer().get();
        return invocationContext.isOriginLocal();
    }

    protected boolean isCacheReady() {
        return this.cache.getStatus() == ComponentStatus.RUNNING;
    }
}

