/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loader.bucket;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.infinispan.container.entries.InternalCacheEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Bucket
implements Externalizable {
    private Map<Object, InternalCacheEntry> entries = new HashMap<Object, InternalCacheEntry>();
    private transient String bucketName;

    public final void addEntry(InternalCacheEntry se) {
        this.entries.put(se.getKey(), se);
    }

    public final boolean removeEntry(Object key) {
        return this.entries.remove(key) != null;
    }

    public final InternalCacheEntry getEntry(Object key) {
        return this.entries.get(key);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.entries.size());
        for (InternalCacheEntry se : this.entries.values()) {
            out.writeObject(se);
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int sz = in.readInt();
        this.entries = new HashMap<Object, InternalCacheEntry>(sz);
        for (int i = 0; i < sz; ++i) {
            InternalCacheEntry se = (InternalCacheEntry)in.readObject();
            this.entries.put(se.getKey(), se);
        }
    }

    public Map<Object, InternalCacheEntry> getEntries() {
        return this.entries;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public boolean removeExpiredEntries() {
        boolean result = false;
        Iterator<Map.Entry<Object, InternalCacheEntry>> entryIterator = this.entries.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<Object, InternalCacheEntry> entry = entryIterator.next();
            if (!entry.getValue().isExpired()) continue;
            entryIterator.remove();
            result = true;
        }
        return result;
    }

    public Collection<? extends InternalCacheEntry> getStoredEntries() {
        return this.entries.values();
    }

    public long timestampOfFirstEntryToExpire() {
        long result = Long.MAX_VALUE;
        for (InternalCacheEntry se : this.entries.values()) {
            if (se.getExpiryTime() >= result) continue;
            result = se.getExpiryTime();
        }
        return result;
    }

    public String toString() {
        return "Bucket{entries=" + this.entries + ", bucketName='" + this.bucketName + '\'' + '}';
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }
}

