/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loader;

import org.infinispan.config.PluggableConfigurationComponent;
import org.infinispan.loader.CacheStoreConfig;
import org.infinispan.loader.decorators.AsyncStoreConfig;
import org.infinispan.loader.decorators.SingletonStoreConfig;
import org.infinispan.util.Util;

public class AbstractCacheStoreConfig
extends PluggableConfigurationComponent
implements CacheStoreConfig {
    private boolean ignoreModifications;
    private boolean fetchPersistentState;
    private boolean purgeOnStartup;
    private SingletonStoreConfig singletonStoreConfig = new SingletonStoreConfig();
    private AsyncStoreConfig asyncStoreConfig = new AsyncStoreConfig();
    private boolean purgeSynchronously = false;
    protected String cacheLoaderClassName;

    public boolean isPurgeSynchronously() {
        return this.purgeSynchronously;
    }

    public void setPurgeSynchronously(boolean purgeSynchronously) {
        this.testImmutability("purgeSynchronously");
        this.purgeSynchronously = purgeSynchronously;
    }

    public String getCacheLoaderClassName() {
        return this.cacheLoaderClassName;
    }

    public void setCacheLoaderClassName(String className) {
        if (className == null || className.length() == 0) {
            return;
        }
        this.testImmutability("cacheLoaderClassName");
        this.cacheLoaderClassName = className;
    }

    public boolean isPurgeOnStartup() {
        return this.purgeOnStartup;
    }

    public boolean isFetchPersistentState() {
        return this.fetchPersistentState;
    }

    public void setFetchPersistentState(boolean fetchPersistentState) {
        this.testImmutability("fetchPersistentState");
        this.fetchPersistentState = fetchPersistentState;
    }

    public void setIgnoreModifications(boolean ignoreModifications) {
        this.testImmutability("ignoreModifications");
        this.ignoreModifications = ignoreModifications;
    }

    public boolean isIgnoreModifications() {
        return this.ignoreModifications;
    }

    public void setPurgeOnStartup(boolean purgeOnStartup) {
        this.testImmutability("purgeOnStartup");
        this.purgeOnStartup = purgeOnStartup;
    }

    public SingletonStoreConfig getSingletonStoreConfig() {
        return this.singletonStoreConfig;
    }

    public void setSingletonStoreConfig(SingletonStoreConfig singletonStoreConfig) {
        this.testImmutability("singletonStoreConfig");
        this.singletonStoreConfig = singletonStoreConfig;
    }

    public AsyncStoreConfig getAsyncStoreConfig() {
        return this.asyncStoreConfig;
    }

    public void setAsyncStoreConfig(AsyncStoreConfig asyncStoreConfig) {
        this.testImmutability("asyncStoreConfig");
        this.asyncStoreConfig = asyncStoreConfig;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof AbstractCacheStoreConfig)) {
                return false;
            }
            AbstractCacheStoreConfig i = (AbstractCacheStoreConfig)obj;
            return this.equalsExcludingProperties(i);
        }
        return false;
    }

    protected boolean equalsExcludingProperties(Object obj) {
        AbstractCacheStoreConfig other = (AbstractCacheStoreConfig)obj;
        return Util.safeEquals(this.cacheLoaderClassName, other.cacheLoaderClassName) && this.ignoreModifications == other.ignoreModifications && this.fetchPersistentState == other.fetchPersistentState && Util.safeEquals(this.singletonStoreConfig, other.singletonStoreConfig) && Util.safeEquals(this.asyncStoreConfig, other.asyncStoreConfig) && Util.safeEquals(this.purgeSynchronously, other.purgeSynchronously);
    }

    public int hashCode() {
        return 31 * this.hashCodeExcludingProperties() + (this.properties == null ? 0 : this.properties.hashCode());
    }

    protected int hashCodeExcludingProperties() {
        int result = 17;
        result = 31 * result + (this.cacheLoaderClassName == null ? 0 : this.cacheLoaderClassName.hashCode());
        result = 31 * result + (this.ignoreModifications ? 0 : 1);
        result = 31 * result + (this.fetchPersistentState ? 0 : 1);
        result = 31 * result + (this.singletonStoreConfig == null ? 0 : this.singletonStoreConfig.hashCode());
        result = 31 * result + (this.asyncStoreConfig == null ? 0 : this.asyncStoreConfig.hashCode());
        result = 31 * result + (this.purgeOnStartup ? 0 : 1);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "className='" + this.cacheLoaderClassName + '\'' + ", ignoreModifications=" + this.ignoreModifications + ", fetchPersistentState=" + this.fetchPersistentState + ", properties=" + this.properties + ", purgeOnStartup=" + this.purgeOnStartup + "}," + ", SingletonStoreConfig{" + this.singletonStoreConfig + '}' + ", AsyncStoreConfig{" + this.asyncStoreConfig + '}' + ", purgeSynchronously{" + this.purgeSynchronously + '}';
    }

    public AbstractCacheStoreConfig clone() {
        AbstractCacheStoreConfig clone = null;
        try {
            clone = (AbstractCacheStoreConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Should not happen!", e);
        }
        if (this.singletonStoreConfig != null) {
            clone.setSingletonStoreConfig(this.singletonStoreConfig.clone());
        }
        if (this.asyncStoreConfig != null) {
            clone.setAsyncStoreConfig(this.asyncStoreConfig.clone());
        }
        return clone;
    }
}

