/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDMBean
implements DynamicMBean {
    private static final Class<?>[] primitives = new Class[]{Integer.TYPE, Byte.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE};
    private static final String MBEAN_DESCRITION = "Dynamic MBean Description";
    private final Log log = LogFactory.getLog(ResourceDMBean.class);
    private final Object obj;
    private String description = "";
    private final MBeanAttributeInfo[] attrInfo;
    private final MBeanOperationInfo[] opInfo;
    private final HashMap<String, AttributeEntry> atts = new HashMap();
    private final List<MBeanOperationInfo> ops = new ArrayList<MBeanOperationInfo>();

    public ResourceDMBean(Object instance) {
        if (instance == null) {
            throw new NullPointerException("Cannot make an MBean wrapper for null instance");
        }
        this.obj = instance;
        this.findDescription();
        this.findFields();
        this.findMethods();
        this.attrInfo = new MBeanAttributeInfo[this.atts.size()];
        int i = 0;
        for (AttributeEntry entry : this.atts.values()) {
            MBeanAttributeInfo info = entry.getInfo();
            this.attrInfo[i++] = info;
            if (!this.log.isInfoEnabled()) continue;
            this.log.trace("Attribute " + info.getName() + "[r=" + info.isReadable() + ",w=" + info.isWritable() + ",is=" + info.isIs() + ",type=" + info.getType() + "]");
        }
        this.opInfo = new MBeanOperationInfo[this.ops.size()];
        this.ops.toArray(this.opInfo);
        if (this.log.isInfoEnabled()) {
            if (this.ops.size() > 0) {
                this.log.trace("Operations are:");
            }
            for (MBeanOperationInfo op : this.opInfo) {
                this.log.trace("Operation " + op.getReturnType() + " " + op.getName());
            }
        }
    }

    Object getObject() {
        return this.obj;
    }

    private void findDescription() {
        MBean mbean = this.getObject().getClass().getAnnotation(MBean.class);
        if (mbean != null && mbean.description() != null && mbean.description().trim().length() > 0) {
            this.description = mbean.description();
            if (this.log.isDebugEnabled()) {
                this.log.debug("@MBean description set - " + mbean.description());
            }
            MBeanAttributeInfo info = new MBeanAttributeInfo(MBEAN_DESCRITION, "java.lang.String", "@MBean description", true, false, false);
            try {
                this.atts.put(MBEAN_DESCRITION, new FieldAttributeEntry(info, this.getClass().getDeclaredField("description")));
            }
            catch (NoSuchFieldException e) {
                this.log.warn("Could not reflect field description of this class. Was it removed?");
            }
        }
    }

    @Override
    public synchronized MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this.getObject().getClass().getCanonicalName(), this.description, this.attrInfo, null, this.opInfo, null);
    }

    @Override
    public synchronized Object getAttribute(String name) throws AttributeNotFoundException {
        if (name == null || name.length() == 0) {
            throw new NullPointerException("Invalid attribute requested " + name);
        }
        Attribute attr = this.getNamedAttribute(name);
        if (attr == null) {
            throw new AttributeNotFoundException("Unknown attribute '" + name + "'. Known attributes names are: " + this.atts.keySet());
        }
        return attr.getValue();
    }

    @Override
    public synchronized void setAttribute(Attribute attribute) {
        if (attribute == null || attribute.getName() == null) {
            throw new NullPointerException("Invalid attribute requested " + attribute);
        }
        this.setNamedAttribute(attribute);
    }

    @Override
    public synchronized AttributeList getAttributes(String[] names) {
        AttributeList al = new AttributeList();
        for (String name : names) {
            Attribute attr = this.getNamedAttribute(name);
            if (attr != null) {
                al.add(attr);
                continue;
            }
            this.log.warn("Did not find attribute " + name);
        }
        return al;
    }

    @Override
    public synchronized AttributeList setAttributes(AttributeList list) {
        AttributeList results = new AttributeList();
        for (int i = 0; i < list.size(); ++i) {
            Attribute attr = (Attribute)list.get(i);
            if (this.setNamedAttribute(attr)) {
                results.add(attr);
                continue;
            }
            if (!this.log.isWarnEnabled()) continue;
            this.log.warn("Failed to update attribute name " + attr.getName() + " with value " + attr.getValue());
        }
        return results;
    }

    @Override
    public Object invoke(String name, Object[] args, String[] sig) throws MBeanException, ReflectionException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Invoke method called on " + name);
            }
            Class[] classes = new Class[sig.length];
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = ResourceDMBean.getClassForName(sig[i]);
            }
            Method method = this.getObject().getClass().getMethod(name, classes);
            return method.invoke(this.getObject(), args);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public static Class<?> getClassForName(String name) throws ClassNotFoundException {
        try {
            Class<?> c = Class.forName(name);
            return c;
        }
        catch (ClassNotFoundException cnfe) {
            for (int i = 0; i < primitives.length; ++i) {
                if (!name.equals(primitives[i].getName())) continue;
                return primitives[i];
            }
            throw new ClassNotFoundException("Class " + name + " cannot be found");
        }
    }

    private void findMethods() {
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(this.getObject().getClass().getMethods()));
        ArrayList<Method> objectMethods = new ArrayList<Method>(Arrays.asList(Object.class.getMethods()));
        methods.removeAll(objectMethods);
        for (Method method : methods) {
            boolean isAlreadyExposed;
            ManagedAttribute attr = method.getAnnotation(ManagedAttribute.class);
            if (attr != null) {
                MethodAttributeEntry mae;
                String methodName = method.getName();
                if (!(methodName.startsWith("get") || methodName.startsWith("set") || methodName.startsWith("is"))) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn("method name " + methodName + " doesn't start with \"get\", \"set\", or \"is\"" + ", but is annotated with @ManagedAttribute: will be ignored");
                    continue;
                }
                MBeanAttributeInfo info = null;
                String attributeName = attr.name().length() > 0 ? attr.name().trim() : null;
                boolean writeAttribute = false;
                if (this.isSetMethod(method)) {
                    attributeName = attributeName == null ? methodName.substring(3) : attributeName;
                    info = new MBeanAttributeInfo(attributeName, method.getParameterTypes()[0].getCanonicalName(), attr.description(), true, true, false);
                    writeAttribute = true;
                } else if (method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE) {
                    boolean hasSetter = this.atts.containsKey(attributeName);
                    if (methodName.startsWith("is")) {
                        attributeName = attributeName == null ? methodName.substring(2) : attributeName;
                        info = new MBeanAttributeInfo(attributeName, method.getReturnType().getCanonicalName(), attr.description(), true, hasSetter, true);
                    } else {
                        attributeName = attributeName == null ? methodName.substring(3) : attributeName;
                        info = new MBeanAttributeInfo(attributeName, method.getReturnType().getCanonicalName(), attr.description(), true, hasSetter, false);
                    }
                } else {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn("Method " + method.getName() + " must have a valid return type and zero parameters");
                    continue;
                }
                AttributeEntry ae = this.atts.get(attributeName);
                if (!writeAttribute) {
                    if (ae instanceof FieldAttributeEntry && ae.getInfo().isReadable()) {
                        this.log.warn("not adding annotated method " + method + " since we already have read attribute");
                        continue;
                    }
                    if (ae instanceof MethodAttributeEntry) {
                        mae = (MethodAttributeEntry)ae;
                        if (!mae.hasSetMethod()) continue;
                        this.atts.put(attributeName, new MethodAttributeEntry(mae.getInfo(), mae.getSetMethod(), method));
                        continue;
                    }
                    this.atts.put(attributeName, new MethodAttributeEntry(info, null, method));
                    continue;
                }
                if (ae instanceof FieldAttributeEntry) {
                    if (ae.getInfo().isWritable()) {
                        this.log.warn("Not adding annotated method " + methodName + " since we already have writable attribute");
                        continue;
                    }
                    Field f = ((FieldAttributeEntry)ae).getField();
                    MBeanAttributeInfo i = new MBeanAttributeInfo(ae.getInfo().getName(), f.getType().getCanonicalName(), attr.description(), true, !Modifier.isFinal(f.getModifiers()), false);
                    this.atts.put(attributeName, new FieldAttributeEntry(i, f));
                    continue;
                }
                if (ae instanceof MethodAttributeEntry) {
                    mae = (MethodAttributeEntry)ae;
                    if (!mae.hasIsOrGetMethod()) continue;
                    this.atts.put(attributeName, new MethodAttributeEntry(info, method, mae.getIsOrGetMethod()));
                    continue;
                }
                this.atts.put(attributeName, new MethodAttributeEntry(info, method, null));
                continue;
            }
            if (!method.isAnnotationPresent(ManagedOperation.class) && !this.isMBeanAnnotationPresentWithExposeAll()) continue;
            ManagedOperation op = method.getAnnotation(ManagedOperation.class);
            String attName = method.getName();
            if (this.isSetMethod(method) || this.isGetMethod(method)) {
                attName = attName.substring(3);
            } else if (this.isIsMethod(method)) {
                attName = attName.substring(2);
            }
            if (isAlreadyExposed = this.atts.containsKey(attName)) continue;
            this.ops.add(new MBeanOperationInfo(op != null ? op.description() : "", method));
        }
    }

    private boolean isSetMethod(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
    }

    private boolean isGetMethod(Method method) {
        return method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE && method.getName().startsWith("get");
    }

    private boolean isIsMethod(Method method) {
        return method.getParameterTypes().length == 0 && (method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class) && method.getName().startsWith("is");
    }

    private void findFields() {
        for (Class<?> clazz = this.getObject().getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                ManagedAttribute attr = field.getAnnotation(ManagedAttribute.class);
                if (attr == null) continue;
                String fieldName = this.renameToJavaCodingConvention(field.getName());
                MBeanAttributeInfo info = new MBeanAttributeInfo(fieldName, field.getType().getCanonicalName(), attr.description(), true, Modifier.isFinal(field.getModifiers()) ? false : attr.writable(), false);
                this.atts.put(fieldName, new FieldAttributeEntry(info, field));
            }
        }
    }

    private Attribute getNamedAttribute(String name) {
        Attribute result = null;
        if (name.equals(MBEAN_DESCRITION)) {
            result = new Attribute(MBEAN_DESCRITION, this.description);
        } else {
            AttributeEntry entry = this.atts.get(name);
            if (entry != null) {
                MBeanAttributeInfo i = entry.getInfo();
                try {
                    result = new Attribute(name, entry.invoke(null));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Attribute " + name + " has r=" + i.isReadable() + ",w=" + i.isWritable() + ",is=" + i.isIs() + " and value " + result.getValue());
                    }
                }
                catch (Exception e) {
                    this.log.debug((Object)("Exception while reading value of attribute " + name), e);
                }
            } else {
                this.log.warn("Did not find queried attribute with name " + name);
            }
        }
        return result;
    }

    private boolean setNamedAttribute(Attribute attribute) {
        AttributeEntry entry;
        boolean result = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Invoking set on attribute " + attribute.getName() + " with value " + attribute.getValue());
        }
        if ((entry = this.atts.get(attribute.getName())) != null) {
            try {
                entry.invoke(attribute);
                result = true;
            }
            catch (Exception e) {
                this.log.warn((Object)("Exception while writing value for attribute " + attribute.getName()), e);
            }
        } else {
            this.log.warn("Could not invoke set on attribute " + attribute.getName() + " with value " + attribute.getValue());
        }
        return result;
    }

    private String renameToJavaCodingConvention(String fieldName) {
        if (fieldName.contains("_")) {
            Pattern p = Pattern.compile("_.");
            Matcher m = p.matcher(fieldName);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, fieldName.substring(m.end() - 1, m.end()).toUpperCase());
            }
            m.appendTail(sb);
            char first = sb.charAt(0);
            if (Character.isLowerCase(first)) {
                sb.setCharAt(0, Character.toUpperCase(first));
            }
            return sb.toString();
        }
        if (Character.isLowerCase(fieldName.charAt(0))) {
            return fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        }
        return fieldName;
    }

    private boolean isMBeanAnnotationPresentWithExposeAll() {
        Class<?> c = this.getObject().getClass();
        return c.isAnnotationPresent(MBean.class) && c.getAnnotation(MBean.class).exposeAll();
    }

    public boolean isManagedResource() {
        return !this.atts.isEmpty() || !this.ops.isEmpty();
    }

    public String getObjectName() {
        MBean mBean = this.obj.getClass().getAnnotation(MBean.class);
        if (mBean != null && mBean.objectName() != null && mBean.objectName().trim().length() > 0) {
            return mBean.objectName();
        }
        return this.obj.getClass().getSimpleName();
    }

    public boolean isOperationRegistred(String operationName) {
        for (MBeanOperationInfo opInfo : this.ops) {
            if (!opInfo.getName().equals(operationName)) continue;
            return true;
        }
        return false;
    }

    private static interface AttributeEntry {
        public Object invoke(Attribute var1) throws Exception;

        public MBeanAttributeInfo getInfo();
    }

    private class FieldAttributeEntry
    implements AttributeEntry {
        private final MBeanAttributeInfo info;
        private final Field field;

        public FieldAttributeEntry(MBeanAttributeInfo info, Field field) {
            this.info = info;
            this.field = field;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
        }

        public Field getField() {
            return this.field;
        }

        public Object invoke(Attribute a) throws Exception {
            if (a == null) {
                return this.field.get(ResourceDMBean.this.getObject());
            }
            this.field.set(ResourceDMBean.this.getObject(), a.getValue());
            return null;
        }

        public MBeanAttributeInfo getInfo() {
            return this.info;
        }
    }

    private class MethodAttributeEntry
    implements AttributeEntry {
        final MBeanAttributeInfo info;
        final Method isOrGetmethod;
        final Method setMethod;

        public MethodAttributeEntry(MBeanAttributeInfo info, Method setMethod, Method isOrGetMethod) {
            this.info = info;
            this.setMethod = setMethod;
            this.isOrGetmethod = isOrGetMethod;
        }

        public Object invoke(Attribute a) throws Exception {
            if (a == null && this.isOrGetmethod != null) {
                return this.isOrGetmethod.invoke(ResourceDMBean.this.getObject(), new Object[0]);
            }
            if (a != null && this.setMethod != null) {
                return this.setMethod.invoke(ResourceDMBean.this.getObject(), a.getValue());
            }
            return null;
        }

        public MBeanAttributeInfo getInfo() {
            return this.info;
        }

        public boolean hasIsOrGetMethod() {
            return this.isOrGetmethod != null;
        }

        public boolean hasSetMethod() {
            return this.setMethod != null;
        }

        public Method getIsOrGetMethod() {
            return this.isOrGetmethod;
        }

        public Method getSetMethod() {
            return this.setMethod;
        }
    }
}

