/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.base;

import java.util.List;
import javax.transaction.Transaction;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.TransactionContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.invocation.Flag;
import org.infinispan.remoting.ReplicationQueue;
import org.infinispan.remoting.ResponseMode;
import org.infinispan.remoting.RpcManager;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.GlobalTransaction;
import org.infinispan.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRpcInterceptor
extends CommandInterceptor {
    private ReplicationQueue replicationQueue;
    protected TransactionTable txTable;
    private CommandsFactory commandsFactory;
    protected RpcManager rpcManager;
    protected boolean defaultSynchronous;
    private boolean stateTransferEnabled;

    @Inject
    public void injectComponents(RpcManager rpcManager, ReplicationQueue replicationQueue, TransactionTable txTable, CommandsFactory commandsFactory) {
        this.rpcManager = rpcManager;
        this.replicationQueue = replicationQueue;
        this.txTable = txTable;
        this.commandsFactory = commandsFactory;
    }

    @Start
    public void init() {
        this.defaultSynchronous = this.configuration.getCacheMode().isSynchronous();
        this.stateTransferEnabled = this.configuration.isFetchInMemoryState();
    }

    protected void checkResponses(List rsps) throws Throwable {
        if (rsps != null) {
            for (Object rsp : rsps) {
                if (rsp == null || !(rsp instanceof Throwable)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Received Throwable from remote cache", (Throwable)rsp);
                }
                throw (Throwable)rsp;
            }
        }
    }

    protected void replicateCall(InvocationContext ctx, CacheRpcCommand call, boolean sync, boolean useOutOfBandMessage) throws Throwable {
        this.replicateCall(ctx, null, call, sync, useOutOfBandMessage);
    }

    protected void replicateCall(InvocationContext ctx, ReplicableCommand call, boolean sync, boolean useOutOfBandMessage) throws Throwable {
        this.replicateCall(ctx, null, call, sync, useOutOfBandMessage);
    }

    protected void replicateCall(InvocationContext ctx, CacheRpcCommand call, boolean sync) throws Throwable {
        this.replicateCall(ctx, null, call, sync, false);
    }

    protected void replicateCall(InvocationContext ctx, ReplicableCommand call, boolean sync) throws Throwable {
        this.replicateCall(ctx, null, call, sync, false);
    }

    protected void replicateCall(InvocationContext ctx, List<Address> recipients, ReplicableCommand c, boolean sync, boolean useOutOfBandMessage) throws Throwable {
        TransactionContext transactionContext;
        long syncReplTimeout = this.configuration.getSyncReplTimeout();
        if (ctx.hasFlag(Flag.FORCE_ASYNCHRONOUS)) {
            sync = false;
        } else if (ctx.hasFlag(Flag.FORCE_SYNCHRONOUS)) {
            sync = true;
        }
        Transaction tx = ctx.getTransaction();
        if (tx != null && (transactionContext = ctx.getTransactionContext()) != null) {
            if (transactionContext.isForceAsyncReplication()) {
                sync = false;
            } else if (transactionContext.isForceSyncReplication()) {
                sync = true;
            }
        }
        this.replicateCall(recipients, c, sync, useOutOfBandMessage, syncReplTimeout);
    }

    protected void replicateCall(List<Address> recipients, ReplicableCommand call, boolean sync, boolean useOutOfBandMessage, long timeout) throws Throwable {
        if (this.trace) {
            this.log.trace("Broadcasting call " + call + " to recipient list " + recipients);
        }
        if (!sync && this.replicationQueue != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Putting call " + call + " on the replication queue.");
            }
            this.replicationQueue.add(call);
        } else {
            List<Address> callRecipients = recipients;
            if (callRecipients == null) {
                callRecipients = null;
                if (this.trace) {
                    this.log.trace("Setting call recipients to " + callRecipients + " since the original list of recipients passed in is null.");
                }
            }
            SingleRpcCommand command = this.commandsFactory.buildSingleRpcCommand(call);
            List<Response> rsps = this.rpcManager.invokeRemotely(callRecipients, command, sync ? ResponseMode.SYNCHRONOUS : ResponseMode.ASYNCHRONOUS, timeout, useOutOfBandMessage, this.stateTransferEnabled);
            if (this.trace) {
                this.log.trace("responses=" + rsps);
            }
            if (sync) {
                this.checkResponses(rsps);
            }
        }
    }

    protected final boolean skipReplicationOfTransactionMethod(InvocationContext ctx) {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        return ctx.getTransaction() == null || gtx == null || gtx.isRemote() || ctx.hasFlag(Flag.CACHE_MODE_LOCAL) || !ctx.getTransactionContext().hasModifications();
    }

    protected final boolean isTransactionalAndLocal(InvocationContext ctx) {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        boolean isInitiatedHere = gtx != null && !gtx.isRemote();
        return isInitiatedHere && ctx.getTransaction() != null;
    }

    protected final boolean isSynchronous(InvocationContext ctx) {
        if (ctx.hasFlag(Flag.FORCE_SYNCHRONOUS)) {
            return true;
        }
        if (ctx.hasFlag(Flag.FORCE_ASYNCHRONOUS)) {
            return false;
        }
        return this.defaultSynchronous;
    }

    protected final boolean isLocalModeForced(InvocationContext ctx) {
        if (ctx.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("LOCAL mode forced on invocation.  Suppressing clustered events.");
            }
            return true;
        }
        return false;
    }
}

