/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.BaseTransactionalContextInterceptor;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class NotificationInterceptor
extends BaseTransactionalContextInterceptor {
    private CacheNotifier notifier;

    @Inject
    public void injectDependencies(CacheNotifier notifier) {
        this.notifier = notifier;
    }

    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (command.isOnePhaseCommit()) {
            this.notifier.notifyTransactionCompleted(ctx.getTransaction(), true, ctx);
        }
        return retval;
    }

    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        this.notifier.notifyTransactionCompleted(ctx.getTransaction(), true, ctx);
        return retval;
    }

    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        this.notifier.notifyTransactionCompleted(ctx.getTransaction(), false, ctx);
        return retval;
    }
}

